#!/usr/bin/python

import Client


SUCCESS     =  0
ERR_CONNECT = -1
ERR_COMMIT  = -2

'''
	Cleaner interface to the paos database
'''
class paos_inter:
	def __init__(self, host, port):
		self.host = host
		self.port = port
	def get_connection(self):
		return Client.Connection(
			self.host, self.port, 'paos_inter')
	def write(self, obj_list, update):
		# get a connection to the data base
		conn = self.get_connection()
		if conn == None:
			return ERR_CONNECT
		
		# are we updating existing objects or adding new ones?
		if update == 0:
			# if we are adding new objects register them
			db_id_list = conn.register_objs(obj_list)	
		else:
			# if we are updating existing ones lock them
			x = conn.lock(obj_list)
			
		
		# commit changes and return results
		ret = None
		try:
			ret = conn.commit(obj_list)
		except:
			return ERR_COMMIT

		# close connection to database
		conn.close()

		# check return value
		if ret == None:	
			return ERR_COMMIT

		return SUCCESS

	def update(self, obj_list):
		return self.write(obj_list, 1)
	def add(self, obj_list):
		return self.write(obj_list, 0)
	def get(self, objname, prop_list, mode='r'):
		conn = self.get_connection()
		answer = conn.get(mode, objname, prop_list)
		conn.close()
		return answer
	def delete(self, obj_list):
		for i in range(0,len(obj_list)): 
			obj_list[i].setDeleted()
		self.update(obj_list)				
