/***********************************************************
Copyright 1991-1995 by Stichting Mathematisch Centrum, Amsterdam,
The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI or Corporation for National Research Initiatives or
CNRI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.

While CWI is the initial source for this software, a modified version
is made available by the Corporation for National Research Initiatives
(CNRI) at the Internet address ftp://ftp.python.org.

STICHTING MATHEMATISCH CENTRUM AND CNRI DISCLAIM ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH
CENTRUM OR CNRI BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

#include "Python.h"
#include "_production.h"

static PyObject *ErrorObject;
#define onError(message) \
	{ PyError_SetString(ErrorObject, message); return NULL; }



/* ----------------------------------------------------- */



static PyObject *
production_new(self, args) /* p = production(text, istag)*/
	PyObject *self;
	PyObject *args;
{
	char *raw;
	int   istag;

	if (!PyArg_ParseTuple(args, "si", &s, &istag))
		return NULL;
	return (PyObject *) PyObject_NEW(production,raw,istag); 	

}


static PyObject *
production_raw(self, args)
	PyObject *self;	
	PyObject *args;
{
	PrObject *res;

	if (!PyArg_ParseTuple(args, ""))
		return NULL;
	return PyString_FromString((const char *)self->raw);
}





/* List of methods defined in the module */

static struct PyMethodDef production_methods[] = {
	{"istag",(PyCFunction)production_istag,	METH_VARARGS,	production_istag__doc__},
	{"raw",	(PyCFunction)production_raw,	METH_VARARGS,	production_raw__doc__},
	
 
	{NULL,	 (PyCFunction)NULL, 0, NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initproduction) */

static char production_module_documentation[] = 
""
;

void
initproduction()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("production", production_methods,
		production_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("production.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module production");
}

