/*


	Make a C representation of the following object:



"""
	Base class for all productions.
	Converts aliases for '<','>' or quote  into literals
	Sets up frame work for derived objects

	Note:
	Must have a no argument constructor for the shelve 
	library. The XMLProcessor might be a remote object.
"""
# basic token representing an entity within an xml file
class production:
	def translate(self, raw):
		kw = [("&quot", "\""),("&lt", "<"),("&gt", ">"),("&amp","&")]
		x = raw
		for (f,r) in kw:
			x = regsub.gsub(f,r,x)
		
		def eval_ascii(t):
			c = regex.compile("&#[0-9]+")
		
			pos = c.search(t)
			if pos == -1: 
				return t		
			width = c.match(t[pos:])
			token = t[ pos: width + pos]
			val = chr( strop.atoi( token[2:] ) )
			t = t[:pos] + token + t[pos+width:]
			return t				 

		return eval_ascii(x)
	def __init__(self, raw = None, istag = false):
		if raw == None: return
		self._istag = istag
		self._raw = self.translate(raw)	
		
	def istag(self):
		return self._istag
		
	def raw(self):
		return self._raw	
*/

#include "_production.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>




char *production_raw(productionobject*self)
{
      	if (self == NULL) return NULL;
	return self->raw;
}

int production_istag(productionobject*self)
{
	if (self == NULL) return NULL;
	return self->istag;
}


void production_translate(productionobject*, char *);

void production_init(productionobject *self, char *raw, char istag)
{
	if (raw == NULL) return;
	self->istag = istag;
	production_translate(self, raw);
}


void replace(char *source, char *pattern, char replace, char **buffer)
{
	char *pos;
	
	if ((pos = strstr(source,pattern)) != NULL)
	{
		char *sptr, *tptr;
		
		/* one time creation cost */
		if (*buffer == NULL)
			*buffer = strdup(source);

		/* copy upto position */		
		for (tptr = *buffer, sptr = source;
		     sptr < pos;
		     tptr++, sptr++)
		{
			*tptr = *sptr;	
		}
		/* insert replacement*/
		*tptr = replace;
		tptr++;
		
		/* copy till end*/
		for (sptr = (char *) pos + strlen(pattern); 
			*sptr != '\0';
			sptr++, tptr++)
		{
			*tptr = *sptr;
		}
		*tptr = '\0';

		strcpy(source, *buffer);
	}
}

void eval_ascii(char *source, char **buffer)
{
	char *pos;
	
	if ((pos = strstr(source,"&#")) != NULL)
	{
		char digits[4], ascii;
		char *sptr, *tptr;
		int i;
		
		/* one time creation cost */
		if (*buffer == NULL)
			*buffer = strdup(source);

		/* copy upto position */		
		for (tptr = *buffer, sptr = source;
		     sptr < pos;
		     tptr++, sptr++)
		{
			*tptr = *sptr;	
		}

		sptr++; /* point past & */
		sptr++; /* point past # */
		
		i = 0;
		while (isdigit(*sptr)){
			digits[i++] = *sptr;
			sptr++;	
			}
		digits[i] = '\0';
		
		if (i > 0){
			*tptr = (char) atoi(digits);
			tptr++;
			}

		/* copy till end*/
		for (; 
			*sptr != '\0';
			sptr++, tptr++)
		{
			*tptr = *sptr;
		}
		*tptr = '\0';
		strcpy(source, *buffer);		
	}
}

/* save on stack creation costs by making global */
struct _aliases
{
	char *pattern;
	char *replacement;
}aliases[] = {
{"&quot", "\""},
{"&lt"  , "<"},
{"&gt", ">"},
{"&amp", "&"},
{0,0} 	
};		


void production_translate(productionobject *self, char *raw)
{
	int i;
	char *buffer;
	
	buffer = NULL;
	
	/* replace aliases */	
	for (i = 0; aliases[i].pattern != 0; i++)
		replace(raw,
			aliases[i].pattern,
			aliases[i].replacement[0],
			&buffer);

	eval_ascii(raw, &buffer);
	
	/* if the buffer was used then it must be equal to raw, don't
	   free it. use it as apposed to a wasted strdup*/		
	if (buffer != NULL){
		self->raw = buffer;
		}   
	else   
	{
		/* we didn't change anything */
		self->raw = strdup(raw);
	}	
}
   void replace(char *source, char *pattern, char replace, char **buffer)
{
	char *pos;
	
	if ((pos = strstr(source,pattern)) != NULL)
	{
		char *sptr, *tptr;
		
		/* one time creation cost */
		if (*buffer == NULL)
			*buffer = strdup(source);

		/* copy upto position */		
		for (tptr = *buffer, sptr = source;
		     sptr < pos;
		     tptr++, sptr++)
		{
			*tptr = *sptr;	
		}
		/* insert replacement*/
		*tptr = replace;
		tptr++;
		
		/* copy till end*/
		for (sptr = (char *) pos + strlen(pattern); 
			*sptr != '\0';
			sptr++, tptr++)
		{
			*tptr = *sptr;
		}
		*tptr = '\0';

		strcpy(source, *buffer);
	}
}

void eval_ascii(char *source, char **buffer)
{
	char *pos;
	
	if ((pos = strstr(source,"&#")) != NULL)
	{
		char digits[4], ascii;
		char *sptr, *tptr;
		int i;
		
		/* one time creation cost */
		if (*buffer == NULL)
			*buffer = strdup(source);

		/* copy upto position */		
		for (tptr = *buffer, sptr = source;
		     sptr < pos;
		     tptr++, sptr++)
		{
			*tptr = *sptr;	
		}

		sptr++; /* point past & */
		sptr++; /* point past # */
		
		i = 0;
		while (isdigit(*sptr)){
			digits[i++] = *sptr;
			sptr++;	
			}
		digits[i] = '\0';
		
		if (i > 0){
			*tptr = (char) atoi(digits);
			tptr++;
			}

		/* copy till end*/
		for (; 
			*sptr != '\0';
			sptr++, tptr++)
		{
			*tptr = *sptr;
		}
		*tptr = '\0';
		strcpy(source, *buffer);		
	}
}

/* save on stack creation costs by making global */
struct _aliases
{
	char *pattern;
	char *replacement;
}aliases[] = {
{"&quot", "\""},
{"&lt"  , "<"},
{"&gt", ">"},
{"&amp", "&"},
{0,0} 	
};		


void production_translate(productionobject *self, char *raw)
{
	int i;
	char *buffer;
	
	buffer = NULL;
	
	/* replace aliases */	
	for (i = 0; aliases[i].pattern != 0; i++)
		replace(raw,
			aliases[i].pattern,
			aliases[i].replacement[0],
			&buffer);

	eval_ascii(raw, &buffer);
	
	/* if the buffer was used then it must be equal to raw, don't
	   free it. use it as apposed to a wasted strdup*/		
	if (buffer != NULL){
		self->raw = buffer;
		}   
	else   
	{
		/* we didn't change anything */
		self->raw = strdup(raw);
	}	
}



/*
	simple command line test, send a string translate a string
*/		
/*
int main(int argc, char *argv[])
{
	productionobjectp;
	
	production_init(&p, argv[1], 0);
	printf("%s\n",p.raw);
	return 0;
}
*/
