"""
Author: David W. Schere, XML toolkit
Copyright (C) 1998 DIDX llc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
02111-1307, USA.


	Remote Querying example.
	Demonstrate howto go a search engine and execute a query

	Goto http://www.infoseek.com and perform a search on
	Monty Python. Print results to stdout.

	1) We create a client that will trap the <form> and
	   <input> tags.
	2) We will then use this information to post a query
	   to the server.
	3) the results are fed to stdout	
"""

# Get a generic client to derive off of.
from XMLClient import ClientBase
from XMLProcessor import XMLProcessor
from XMLFactory import tag
from socket import *
import strop, sys, regsub

CantProcess = "example2.CantProcess"


false,true = 0,1

#*****
#	Used to parse the http://www.infoseek.com form
#	or any other search engine for that matter.
#
#	Client objects recieve tags frocessed by the XMLFactory
#       the factory is hidden within the XMLProcessor. All one
#	has to do to process any html or xml form is derive a 
#	new client off of ClientBase and send it the the XMLProcessor
#	along with the url.
#
#	Each tag is represented by an entity object. 
#	It is usually called 'obj' and has the following methods 
#	obj.nameOf() -> If obj represents the tag <input  ... 
#		        then nameOf() will return 'input'. nameOf()
#			returns the tag identifier
#	obj["name"]  -> all attributes are accessed by the [] operator.
#			if obj 
#
class RemoteQueryClient(ClientBase):
	def __init__(self, sargs):
		ClientBase.__init__(self)
		self.input = {}
		self.url = None
		self.method = None
		self.sargs = sargs
		
	#*****
	# nonEmptyTag
	# 	this will be called for all tags which have the pattern <...>
	def nonEmptyTag(self, obj):	
		# get the name of entity, if <input ... > then obj.nameOf()
		# will return input
		n = strop.upper(obj.nameOf())

		if n == "INPUT":
			try:
				type = strop.upper(obj["type"])			
			except:
				type = "TEXT"

			name = obj["name"]
			try:
				value = obj["value"]			
			except:
				value = ""

			if   type == "TEXT":
				value = self.sargs
			elif type == "SUBMIT":
				return
			elif type == "RADIO":
				# select the first one unless 
				# the checked flag is present in the tag
				if obj.has_key("checked") == true:
					self.input[name] = value
					return
			
			if not self.input.has_key(name):		
				self.input[ name ] = value

		elif n == "FORM":
			print "form ", vars(obj)
			# extract the action attribute
			if obj.has_key("action") == true:
				self.url = obj["action"]
			else:
				msg = "action attribute missing from form tag!"
				raise CantProcess, msg			

			try:
				self.method = strop.upper( obj["method"] )
			except:
				self.method = "GET"
											 	    		
		ClientBase.nonEmptyTag(self, obj)

	#*****
	# endTag
	#	this is called when we reach a </ ... > tag
	def endTag(self, obj):
		# get the name of entity, if <input ... > then obj.nameOf()
		# will return input
		n = strop.upper(obj.nameOf())
		
		if n == "FORM": 
			#*** We don't have to parse the rest of this file ***
			# direct the XMLFactory object to terminate the parsing
			# process now!
			self.setAbort()
			
		ClientBase.endTag(self, obj)


	def endfile(self):
		pass

target = "http://www.infoseek.com/"
try:
	target = sys.argv[1]
except:
	pass

search = "Monty Python"
try:
	search = sys.argv[2]
except:
	pass


# Create the client
c = RemoteQueryClient(search)
# Create a processor
x = XMLProcessor(c)
# have the client use the processor to parse the file
x.run( target )

# get the url inside the form tag
cgiscript = c.url
# get the name of the text box where to "type in" the search arguments
input = c.input
# use the post method
method = c.method

print cgiscript, input, method


# the encoder module will create a query string
# for the server
import encoder
message = encoder.formatQuery(method, cgiscript, input)


#------ begin socket connection stuff ---------
# standard socket
s = socket(AF_INET, SOCK_STREAM)

# 99.9 percent of web servers are on socket 80
# however this can be changed by going
# http://www.nnn.org:<port number>/
# this subroutine handles this exception
import query
host, port = query.extract_host_and_port(target)


# connect us
s.connect(host, port)	

# send the message to server
print message
s.send(message)
	
while 1:
	data = s.recv(4096)

	if data == None: break
        if data == "": break

	data = regsub.gsub('\r','',data)
	# send data to stdout
	print data,
		
# close the socket	
s.close()




