"""
Author: David W. Schere, XML toolkit
Copyright (C) 1998 DIDX llc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
02111-1307, USA.
""""""
	Encoding for GET and POST methods
"""

import regex, strop

Error = "Error.encoder"


def encode_word(x, word):
	if type(word) != type(""):
		print word
		import sys; sys.exit(0)

	result = ""
	for c in word:
		if x.match(c) == -1:
			if c == " ":
				result = result + "+"
			else:
				result = result + "%" + "%02x" % (ord(c))
		else:
			result = result + c
	return result
	
def encode(dict):
	result = ""
	x = regex.compile("[a-zA-Z_]")
	for (k,v) in dict.items():
		if v == None:
			msg = "%s == None" % (k)
			raise Error, msg 
		if len(result) > 0:
			result = result + "&"		
		result = result + "%s=%s" % (encode_word(x,k),encode_word(x,v))
		
	return result		
	
#*****
# main function of module
# 	formats a request to a server using either GET or POST
def formatQuery(method, cgi, dict):
	method = strop.upper(method)	
	q = encode(dict)
	if method == "GET":
		msg = "GET %s?%s HTTP/1.0" % (cgi,q)
	else:
		msg = """POST %s HTTP/1.0
Conent-type: application/x-www-form-urlencoded
Content-length: %s


%s"""
		msg = msg % (cgi,len(q),q)

	trailer = """
Accept: text/html
Accept: text/plain
User-Agent: Bond/James Bond libwww/2.1.4

"""
	msg = msg + trailer
	return msg			
	
	
if __name__ == "__main__":
	import sys
	dict = {'name':'pheno barbitol','email':'joe@blow.98.com'}
	cgi = "http://www.bbb.ccc/kjh/lk/t.cgi"
	print formatQuery(sys.argv[1],cgi,dict)
	
	