"""
Author: David W. Schere, XML toolkit
Copyright (C) 1998 DIDX llc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
02111-1307, USA.


	This module processes a dtd for an XML file. The dtd is like a grammar file which
	tells the XMLProcessor what tags are legal and what are not.	


	Operation:
		Create two clients one for parsing the dtd the other
		uses the information obtained by the dtd to parse an
		XML file.

"""
import XMLClient, XMLProcessor, XMLFactory, strop

MalformedDTD = "dtd.MalformedDTD"

def get_options(x):
	mask, type = [], "or"
	if   x.__class__ == XMLFactory.Expr().__class__:
		type = x.exprType()				
		for sym in x.value():
			mask.append( sym.value() )
	elif x.__class__ == XMLFactory.Symbol().__class__:
		mask.append( x.value() )
	return mask, type		



#*****
# class element
# 	represents a <!ELEMENT ... > tag
class element:
	def __init__(self, obj):
		list = obj.value()
		if len(list) != 2:
			msg = "two attributes are required for a ELEMENT tag"
			raise MalformedDTD, msg

		self._id = list[0].value()
		x = list[1]
		self.mask, self.type = get_options(x)

	def getId(self):
		return self._id
	def getMask(self):
		return self.mask
	def getType(self):
		return self.type

	def show(self):
		print "id   = ",self._id
		print "mask = ",self.mask
		print "type = ",self.type

#****
# attr_spec
#	speciicatiosn for each attribute of a tag
#	determines whether or not a attribute is optional
#	and what values it may have.
class attr_spec:
	def proc(self, list):
		self.attrname = list[0]
		if list[1].__class__ == XMLFactory.Symbol().__class__:
			sym = list[1]
			symval = sym.value()
			if symval[0] == "#":
				# the option term is null
				self.mask, self.type = [], "or"
				self.status = symval
				return list[2:]
		
		self.mask, self.type = get_options(list[1])

		print list[1].value()
		self.status = list[2].value()
		try:
			return list[3:]
		except:
			return []

	def show(self):
		print "Attribute name ",self.attrname
		print "mask   ",self.mask
		print "type   ",self.type
		print "status ",self.status
	

#****
# class attlist
#	represents a <!ATTLIST ... > tag
class attlist:
	def __init__(self, obj):
		self.specs = []

		list = obj.value()
		self._id = list[0]

		list = list[1:]
		while len(list) > 0:
			spec = attr_spec()
			#try:
			list = spec.proc(list)
			#except:
			#	raise MalformedDTD, "Error in attribute specification"
			self.specs.append( spec )
	def id(self):
		return self._id
	
	def show(self):
		print "Element name: ", self._id
		for s in self.specs:
			s.show()
			 
#*****
# class dtdClient
#	parse a dtd file for an xml. Create a object that will
#	be used later by the ValidatingClient to provide symantic 
#	error checking for an xml document. 		
class dtdClient(XMLClient.ClientBase):
	def __init__(self):
		XMLClient.ClientBase.__init__(self)
		self.elements = []
		self.attlists = []

	def dtd(self, obj):
		n = strop.upper( obj.nameOf() )
		if   n == "ELEMENT":
			e = element( obj )
			self.elements.append(e)
		elif n == "ATTLIST":
			a = attlist( obj )
			self.attlists.append(a)	

	def show(self):
		for e in self.elements:
			e.show()
		for a in self.attlists:
			a.show()



if __name__ == '__main__':
	c = dtdClient()
	x = XMLProcessor.XMLProcessor(c)
	import sys	
	x.run( sys.argv[1] )


	c.show()
	 

