"""
Author: David W. Schere, XML toolkit
Copyright (C) 1998 DIDX llc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
02111-1307, USA.


	This is a client that parses a rules file to create
	a set of rules for parsing of XML files. A rules
	file is itself an XML file.


	<rule event=<XML event> nameOf=<specific name> >
		action
	</rule>

	<start>
		creation of data structures 
	</start>

	<end>
		exporting created items
	</end>
		
"""

from strop import *
import regex
from XMLClient import ClientBase

false, true = 0, 1



# adjust the tabbing level. Usually the tabbing level altered
# because of theis effect:
# <rule event=nonEmptyTag nameOf=select>
#	Doc.rules["traptext"].enabled()
# 	if blah == blah:
#		...
#
# Note that there is a tab infront of Doc that will result in
# a scope error. Without this adjustment all code would have to be left
# justified.
def adjust_code(code):
	l = []
	rl = splitfields(code,"\n")
		
	# used to adjust tab level
	x = regex.compile("[\t ]+")
	header = x.match( rl[1] )
	
		
	for p in rl[1:]:
		if len(p) > header: 
			p = p[header:]
			l.append( p )
	l.append("\n")
				
	return joinfields(l,"\n")	

	

class rule:
	def __init__(self, obj = None):
		if obj == None: return
		
		if obj.has_key("disable"):
			self.enable = false
		else:
			self.enable = true
		if not obj.has_key("event"):
			self.event = None
		else:
			self.event = obj["event"]
		if not obj.has_key("nameOf"):
			self.nameOf = obj["name"]	
		self.theObj = obj	
			
	def getobj(self):
		return self.theObj		
	def enabled(self):
		self.enable = true
	def disabled(self):
		self.enable = false
	def setcode(self, obj):
		self.code = adjust_code( obj.value() )
	def getcode(self):
		return self.code	
	def event_test(self, eventname):
		if self.event == None: return true
		if upper(eventname) == upper(self.event): return true
		return false

	def nameOf_test(self, obj):
		if self.nameOf == None: return true
		try:
			if upper(obj.nameOf()) == upper(self.nameOf):
				return true
		except:
			pass
		return false

	def match(self, event, obj):
		if self.enable == false: return false
		if self.event_test(event) == true:
			if self.nameOf_test(obj) == true:
				return true
		return false	
			
class rule_table:
	def __init__(self):
		self.list = []
	def append(self, r):
		if r != None:
			self.list.append(r)
	def __getitem__(self, key):
		if type(key) == type(0):
			if key >= 0 and key < len(self.list):
				return self.list[key]
		elif type(key) == type(""):	
			for r in self.list:
				obj = r.getobj()
				n = obj["name"]
				if n != None:
					if n == key:
						return obj
		return None
				
								   
class RulesGeneratorClient(ClientBase):
	def __init__(self):
		ClientBase.__init__(self)
		self.rules = rule_table()
		self.start_code = None
		self.end_code = None
	def trap_start(self, obj):
		self.start_code = adjust_code( obj.value() )
	def trap_end(self, obj):
		self.end_code = adjust_code( obj.value() )	
	def endTag(self, obj):
		ClientBase.endTag(self, obj)
	def nonEmptyTag(self, obj):
		ClientBase.nonEmptyTag(self, obj)
		n = upper( obj.nameOf() )
		if   n == "RULE":
			r = rule(obj)
			self.rules.append(r) 
			ClientBase.setTextHandler(self, r.setcode)
		elif n == "START":
			ClientBase.setTextHandler(self, self.trap_start)
		elif n == "END":
			Clientbase.setTextHandler(self, self.trap_end)
	
def GenerateRules(rulesURL):
	from XMLProcessor import *
	r = RulesGeneratorClient()
	x = XMLProcessor( r )
	x.run( rulesURL )
	return r

CodeException = "XMLRulesClient.RulesBasedClient"
	
	
class RuleBasedClient(ClientBase):
	def create_module(self, r):
		# create a temporary module to house 
		# def, class in start code
		import tempfile
	
		
		x = tempfile.mktemp()
		x = splitfields(x,"@")[1]
		modname = "M"+splitfields(x,".")[0]
		self.modfile = modname+".py"		
		
		id = "[a-zA-Z_][0-9A-Za-z_]*"
		fc = regex.compile("def \(%s\)" % (id))
		cc = regex.compile("class \(%s\)" % (id))
	
		file = open(self.modfile,"w")
		inside_prod = false
		for line in splitfields(r.start_code,"\n"):
			if len(line) == 0:
				continue
		
			if inside_prod == true:
				if line[0] in ('\t',' '):
					# write body of a declaration
					file.write(line+"\n")
				else:
					# we are no longer in the declaration
					inside_prod = false
					
			if   fc.match(line) != -1:
				f = fc.group(1)
				# write out function declaration
				file.write(line+"\n")
				inside_prod = true
			elif cc.match(line) != -1:
				c = cc.group(1)
				# write class declaration
				file.write(line+"\n")
				inside_prod = true
		file.close()
		self._importmod = "from %s import *\n" % (modname)							
		
		
	def __init__(self, rulesURL):
		ClientBase.__init__(self)
		r = GenerateRules(rulesURL)
		self._importmod = None
		# execute startup code
		self.startup_code(r)
		# create a module that rules import
		self.create_module(r)
		
		self.therule = r
		
	def exec_code(self, code, Obj = None):
		if self._importmod != None:
			code = self._importmod + code

		Doc = self
		CompiledCode = compile(code, "<string>", "exec")
		#try:
		exec(CompiledCode)
		#except:
		#	raise CodeException, code 
		self = Doc		

		
	def startup_code(self, r):
		# transfer all rules objects			
		self.rule = r.rules	

		if r.start_code != None:
			self.exec_code(r.start_code)
			
	def test(self, eventname, obj):
		for r in self.rule.list:
			if r.match(eventname, obj):
				code = r.getcode()
				print "executing code for ",obj.nameOf()
				self.exec_code(code, obj)

	def endfile(self):
		ClientBase.endfile(self)
		if self.therule.end_code != None:
			self.exec_code(r.end_code)
		import os
		try:
			os.system("rm %s" % (self.modfile+"*"))
		except:
			os.system("del %s" % (self.modfile+"*"))	
			
	def text(self, obj):
		ClientBase.text(self, obj)
		self.test("text",obj)
		
	def emptyTag(self, obj):
		ClientBase.emptyTag(self, obj)
		self.test("emptyTag",obj)
				
	def nonEmptyTag(self, obj):
		# a workaround for html files
		implied_empty = ("HR","P","BR", "INPUT")
		if upper(obj.nameOf()) in implied_empty:
			self.emptyTag(obj)
		else:
			ClientBase.nonEmptyTag(self, obj)
			self.test("nonEmptyTag",obj)
		
	def dtd(self, obj):
		ClientBase.dtd(self, obj)
		self.test("dtd",obj)
	
#
# Parse an html or xml file based on a set of rules 
# targetURL - html file
#	
def Parse(targetURL, rulesURL):
	from XMLProcessor import XMLProcessor

	client = RuleBasedClient(rulesURL)
	XMLProcessor(client).run(targetURL)
	# return dynamically built class
	return client
	
							
	
	
#----------------- test harness -------------------------
if __name__ == '__main__':
	import sys
#	r = GenerateRules( sys.argv[1] )
	
#	print r.start_code
#	print r.rules
#	print r.end_code

	d = Parse( sys.argv[1], sys.argv[2] )
	print vars(d)
	











	
	
	
		
					
			

