"""
Author: David W. Schere, XML toolkit
Copyright (C) 1998 DIDX llc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
02111-1307, USA.

	Processor for a WIDL type XML document.
"""

false,true = 0,1
from XMLProcessor import XMLProcessor
from WIDLElements import *  


gnumessage = """
This is free software protected under the GPL license.
Enjoy :)
"""


#*****
# widlDocClient 
#	a DocClient that parses the widl file into a Doc object
class widlDocClient(DocClient):
	def __init__(self):
		DocClient.__init__(self)
		self.grove = widlEntity()  	 

def callScript(doc):
	import strop

	# setup API for python script
	callService = doc.callService

	# get script element
	script = doc.SCRIPT[0]

	# get source code
	source = script.source
	# determine language	
	language = strop.upper(script.getlanguage())

	#print "executing script ",source
	if language == "PYTHON":
		code = compile(source,"<string>","exec")
		exec(code)
	else:
		UnImplimentedFeature = "WIDLProcessor.UnImplimentedFeature"
		msg = "Language binding to %s not completed yet" % (language)
		raise UnImplimentedFeature, msg

def execute(widlFile):
	c = widlDocClient()
	x = XMLProcessor(c)
	x.run(widlFile)
 
	g = c.getGrove() 

	# for each widl tag
	for i in range(0, g.WIDL.length()):
		doc = g.WIDL[i]
		callScript(doc)






if __name__ == "__main__":
	import sys
	print gnumessage
	execute(sys.argv[1])
