"""
Author: David W. Schere, XML toolkit
Copyright (C) 1998 DIDX llc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
02111-1307, USA.

	A collections of objects that represent tags in a
	widl document. They are produced by a special client
        for processing *.widl files. 
"""
false,true=0,1
from WIDLDocObject import widlDocObject, widlDocArray, DocClient
from XMLFactory import tag
import strop



#****
# create a WIDLElement as apposed to a widlDocElement
def createElement(index, obj):
	dict = {"WIDL": widl(),
		"VARIABLE": variable(),
		"REGION": region(),
		"CONDITION":condition(),
		"BINDING":binding(),
		"SERVICE":service(),
		"SCRIPT":script()}
	for (k,d) in dict.items():
		if strop.upper(obj.nameOf()) == k:
			d.setup(index,obj)
			return d
	msg = "Unknown tag name %s in widl document" % (obj.nameOf())
	raise WIDLMalformed, msg


#****
# a an array of widl elements
class array(widlDocArray):
	def __init__(self):
		widlDocArray.__init__(self)
	def append(self, index, obj):
		e = createElement(index, obj)
		self.list.append(e)



#**** 
# class widlEntity
# 	represents a special Doc object that represents a widl file
class widlEntity(widlDocObject):
        def __init__(self):
                widlDocObject.__init__(self)

	#*****
	# overload add method, this method adds new elements to the widl
	# document object
	def add(self, index, stack, obj, firstpass = true):
		if firstpass == true:
			firstpass = false
			if obj.__class__ == tag().__class__:
				if obj.has_key("name"):
					w = createElement(index,obj)
					setattr(self,obj["name"],w)
			
		if len(stack) == 1:
			self.do_add(index, obj)
		elif len(stack) > 1:
			a = getattr(self, stack[0].nameOf())
			a.list[ len(a.list)-1 ].add(index,stack[1:],obj,firstpass)

	#*****
	# overload helper function of add as well.
        def do_add(self, index, obj):
                n = obj.nameOf()
                if n != None:
                        if not hasattr(self,n):
                                a = array()
                        else:
                                a = getattr(self,n)
                        a.append(index, obj)
                        setattr(self,n,a)



WIDLRequiredAttributeMissing = "WIDLElements.WIDLRequiredAttributeMissing"
WIDLMalformed = "WIDLElements.WIDLMalformed" 


#*****
# get a required arameter from a enitity tag. If not found raise an
# exception
def required_param(obj,name,tagname):
	x = obj[name]
	if x == None:
		msg = "Attribute %s missing in %s" % (name,tagname)
		raise WIDLRequiredAttributeMissing, msg
	return x

#*****
# get an optional parameter, if it doesn't exist return default value
def optional_param(obj,name,_default):
	x = obj[name]
	if x == None:
		return _default
	return x  

#*****
# DIDX's addition to the spec to allow for manipulation of widl documents
# via a scripting language. No great feek because it was written in a
# scripting language :))
class script(widlEntity):
	def __init__(self):
		widlEntity.__init__(self)
	def setup(self, index, obj):
		widlEntity.setup(self,index,obj)
		self._language = optional_param(obj,"language","python")	
	def getlanguage(self):
		return self._language

#*****
# parent element for WIDL, it defines an interface. Interfaces being
# groupings of bindings and related services.
class widl(widlEntity):
	def __init__(self):
		widlEntity.__init__(self)
	def setup(self, index, obj):
		widlEntity.setup(self,index,obj)
		self._name     = optional_param(obj,"name","")
		self._version  = optional_param(obj,"version","2.0")
		self._template = optional_param(obj,"template","")
		self._baseurl  = optional_param(obj,"baseurl","")
		self._objmodel = optional_param(obj,"objmodel","wmdom")

	# use input and output bindings to execute the named service
	def callService(self, name, indict):
		from APIService import execute
		return execute(self, name, indict)		
			
	def getbaseurl(self):
		return self._baseurl

		 
	 
		
#*****
# child of widl tag
class service(widlEntity):
	def __init__(self):
		widlEntity.__init__(self)
	def setup(self, index, obj):
		widlEntity.setup(self,index,obj)
		self._name     = required_param(obj,"name","service")
		self._url      = required_param(obj,"url","service")
		self._method   = optional_param(obj,"method","Get")
		self._input    = optional_param(obj,"input","")
		self._output   = optional_param(obj,"output","")
		self._authuser = optional_param(obj,"authuser","")  	
		self._authpass = optional_param(obj,"authpass","")	
		self._timeout  = strop.atoi(optional_param(obj,"timeout","0"))
		self._retries  = strop.atoi(optional_param(obj,"retries","0"))
	def getmethod(self):
		return self._method
	def gettimeout(self):
		return self._timeout
	def getretries(self):
		return self._retries
	def geturl(self):
		return self._url
	
	# use input and output 
	def execute(self, widlObj):
		pass	
	def getinput(self):
		return self._input
	def getoutput(self):
		return self._output
	def getname(self):
		return self._name

#*****
# class binding - parent tag of variable, codition and region.
# this bindsan activity to either an input o a url or and output
class binding(widlEntity):
	def __init__(self):
		widlEntity.__init__(self)
	def setup(self, index, obj):
		widlEntity.setup(self,index,obj)
	 	self._name     = required_param(obj,"name","binding")
		self._type     = optional_param(obj,"type","Output")

#*****
# class variable
#	represents input or out parameters
class variable(widlEntity):
	def __init__(self):
		widlEntity.__init__(self)
	def setup(self, index, obj):
		widlEntity.setup(self,index,obj)
		self._name     = required_param(obj,"name","vaiable")
		self._formname = optional_param(obj,"formname",self._name)
		self._type     = optional_param(obj,"type","String")
		self._usage    = optional_param(obj,"usage","Default")
		self._reference= optional_param(obj,"reference","")
		self._value    = optional_param(obj,"value","")
		self._mask     = optional_param(obj,"mask","")
		self._nullok   = optional_param(obj,"nullok","False")
	def getusage(self):
		return self._usage
	def getvalue(self):
		return self._value
	def setvalue(self, x):
		self._value = x
	def getname(self):
		return self._name
	def getformname(self):
		return self._formname
	def getreference(self):
		return self._reference
#*****
# class condition	
class condition(widlEntity):
	def __init__(self):
		widlEntity.__init__(self)
	def setup(self, index, obj):
		widlEntity.setup(self,index,obj)
		self._type     = optional_param(obj,"type","Success")
		self._ref      = required_param(obj,"reference","condition")
		self._match    = required_param(obj,"match","condition")
		self._rebind   = optional_param(obj,"rebind","")
		self._service  = optional_param(obj,"service","")
		self._reasonref= optional_param(obj,"reasonref","")
		self._reasontext=optional_param(obj,"reasontext","")
		self._wait     = strop.atoi(optional_param(obj,"wait","0"))
		self._tries  = strop.atoi(optional_param(obj,"retries","0")) + 1
	def getmatch(self):
		return self._match
	def gettype(self):
		return self._type
	def getreference(self):
		return self._ref

#*****
# class region
class region(widlEntity):
	def __init__(self):
		widlEntity.__init__(self)
	def setup(self, index, obj):
		widlEntity.setup(self,index,obj)
		self._name     = required_param(obj,"name","region")
		self._start    = required_param(obj,"start","region")
		self._end      = required_param(obj,"end","region")
	 		

 	

