"""
Author: David W. Schere, XML toolkit
Copyright (C) 1998 DIDX llc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
02111-1307, USA.


	The widl document object
"""

AttrAlias = (('txt','text'),('val','value'),('src','source'),('idx','index'),('reference','ref'))


from XMLFactory import tag, rawText
import regex, regsub, strop

false,true = 0,1

InvalidCommand = "WIDLDocObj.InvalidCommand"




class widlDocElement:
	def __init__(self):
		pass
	def setup(self, index, obj):
		self.index = index
		self.obj = obj
		if obj.__class__ == rawText().__class__:
			self.text = obj.value()
			self.source = ""
		elif obj.__class__ == tag().__class__:
                        #self.text = ""
                        if hasattr(obj,"text"):
                                self.text = obj.text

			self.source = obj.getText()
			if obj.has_key("value"):
				self.value = obj["value"]
			else:
				self.value = ""
		self.reference = self	
	def setText(self, text):
		self.text = text
        def clone(self):
                x = self
                x.text = self.text
                return x
	
class widlDocArray:
	def __init__(self):
		self.list = []
	def length(self):
		return len(self.list)
	def append(self, index, obj):
		e = widlDocObject()
		e.setup(index, obj)
		self.list.append(e)
	def last(self):
		return self.list[ len(self.list) - 1 ]
	def raw_append(self, e):
		self.list.append(e)
	def test(self, obj, dict):
		for (n,v) in dict.items():	
			if obj.has_key(n) == false:
				return false
			if obj[n] != v:
				return false
		return true		
	def __call__(self, **dict):
		for e in self.list:
			if self.test(e.obj,dict) == true:
				return self.fixup(e)
		return None		

	def fixup(self, e):
		class make_list:
			def __init__(self):
				self.list = []
			def for_each(self, x):
				for (n,o) in vars(x).items():
					if not hasattr(o,"__class__"):
						continue
							
					if o.__class__ == widlDocObject().__class__:
						if o.obj.has_key("name") == true:	
                                                        self.list.append(o)
					elif o.__class__ == widlDocArray().__class__: 
						for _x in o.list:
							self.for_each(_x)
			def fixup(self, e):
				for o in self.list:
					setattr(e,o.obj["name"],o)				
				return e	
		m = make_list()
		m.for_each(e)
		return m.fixup(e)
						
	def __getitem__(self, k):
		if type(k) == type(0):
			try:
				return self.fixup(self.list[k])	
			except:
				return None		
		else:
			for (s,r) in (('\*','.'),('\?','[^ ]')):
				k = regsub.gsub(s,r,k)
			x = regex.compile(k)
			for e in self.list:
				if e.has_key("value"):
					v = s["value"]
					if x.search(v) != -1:
						return self.fixup(e)
			return None						



#*****
# foreach
#	Iterate through all elements of a doc object and pass them to 
#	func
def foreach(w, func):
	for (attr, o) in vars(w).items():
		if not hasattr(o,"__class__"):
			continue
		if   o.__class__ == widlDocArray().__class__:
			for i in range(0,o.length()):
				if foreach(o[i],func) == true:
					return true
		elif o.__class__ == widlDocObject().__class__:
			if func(o) == true:
				return true
	return false	

	



def dump(w, indent):
	for (attr, o) in vars(w).items():
		if not hasattr(o,"__class__"):
			continue

		if o.__class__ == widlDocArray().__class__:
			i = " " * indent
			msg = "%s[%s]" % (i,attr)
			print msg
			for i in range(0,o.length()):
				dump(o[i],indent+4)							
		if o.__class__ == widlDocObject().__class__:
			i = " " * indent
                        msg = "%s<%s>" % (i,vars(o))
			print msg


RawTextClass = rawText().__class__

class widlDocObject(widlDocElement):
	def __init__(self):
		widlDocElement.__init__(self)
		self.lasttag = ""
	def findall(self, name):
		return self.find(name, true)

	def find(self, name, all = false):
		class match:
			def __init__(self, name, all):
				self.name = name
				self.all = all
				if self.all == false:
					self.target = None
				else:
					self.target = []
			def test(self, w):
				if strop.upper(self.name) == strop.upper(w.obj.nameOf()):
					if self.all == false:
						self.target = w
					else:
						self.target.append(w)	
					return true
				return false
	
		m = match(name, all)
		result = foreach(self, m.test)			
		target = m.target
		return target

	def __call__(self, **dict):
		class match:
			def __init__(self, dict):
				self.dict = dict
				self.target = None
			def test(self, w):
				result = 0
				for (k,v) in self.dict.items():
					if not w.obj.has_key(k):
						return false
					if w.obj[k] != v:
						return false
					result = result + 1
				if result != len(dict.keys()):
					return false
				self.target = w
				return true
		m = match(dict)
		result = foreach(self, m.test)			
		target = m.target
		return (result, target)
				
			
	def dump_structure(self):
		dump(self,0)					

	def subTree(self, start, end):
                class doSubTree:
                        def __init__(self):
                                self.grove = widlDocObject()
                                self.list = []
                                
                        def foreach(self, x, low, high, level = 0):
                                for (n,o) in vars(x).items():
					if not hasattr(o,"__class__"):
                                                continue
                                   
					if o.__class__ == widlDocObject().__class__:
                                                if o.index > low and high > o.index:
                                                        self.list.append( (level, o) )
					elif o.__class__ == widlDocArray().__class__:
						for _x in o.list:
                                                        self.foreach(_x,low,high,level+1)

                        def execute(self):
                                lastlevel, index, stack = -1, 0, []
                                for (level, o) in self.list:
                                        if lastlevel < level:
                                                stack.append(o.obj)
                                                lastlevel=level
                                        elif lastlevel > level:
                                                del stack[ len(stack)-1 ]
                                                lastlevel=level

                                        obj = o.obj
                                        obj.text = o.text
                                        self.grove.add(index, stack, obj)
                                        index=index+1
                                

                n = doSubTree()
                n.foreach(self, start.index, end.index)
                n.execute()
                return n.grove

	def add(self, index, stack, obj, firstpass = true):
		if firstpass == true:
			firstpass = false
			if obj.__class__ == tag().__class__:
				if obj.has_key("name"):
					w = widlDocElement()
					w.setup(index,obj)
					setattr(self,obj["name"],w)
					
		# Too slow of an algorithm
		"""
		if len(stack) == 1:
			self.do_add(index, obj)
		elif len(stack) > 1:
			a = getattr(self, strop.upper(stack[0].nameOf()))
			a.list[len(a.list)-1].add(index,stack[1:],obj,firstpass)
		"""

		cmd, i = "self", 0
		if len(stack) == 0:
			return 

		while 1:
			if i < len(stack)-2:
				cmd = cmd + ".%s.last()" % (stack[i].nameOf())
				i = i + 1
			else:
				cmd = cmd + ".do_add(index,obj)"
				x=compile(cmd,"<string>","exec")
#				print cmd
				exec(x)
				return
					

		
				 	
				

	def do_add(self, index, obj):
		if obj.__class__ == RawTextClass:
			if hasattr(self,self.lasttag):
				a = getattr(self,self.lasttag)
				child = a.list[ len(a.list)-1 ]
				child.setText( obj.value() )
				a.list[ len(a.list)-1 ] = child		
				setattr(self,self.lasttag,a)
				return

		n = strop.upper(obj.nameOf())
		try:
			a = getattr(self,n)
		except:
			a = widlDocArray()			

		a.append(index,obj)
		setattr(self,n,a)
		self.lasttag = n
					
		
"""
	A widl document object. This is that data model for all manipulations
	by widl.
"""

from XMLClient import ClientBase
from XMLProcessor import XMLProcessor
from strop import *	

# in html there are implied empty tags. That is there are tags like
# <p> which syntacally would have a </P> but don't
IMPLIED_EMPTY_TAGS = ("INPUT","HR","P","BR","META")


#****
# class DocClient
#	Uses a file to create a grove object, this is a tree structure
#	represented by the widlDocObject
class DocClient(ClientBase):
	def __init__(self):
		ClientBase.__init__(self)
		self.grove = widlDocObject()	
		self.index = 0		
		self.curr_tag = None
		self.thestack = []
        
	def getGrove(self):
		return self.grove	

	def add(self, obj):
#		print "adding ",obj
		self.grove.add(self.index, self.getStack(), obj )
		self.index = self.index + 1
		
		
	# --- overload base methods ----------
	def nonEmptyTag(self, obj):
		from XMLFactory import tag
		if tag().__class__ != obj.__class__:
			print "not being passed a tag object!"
			raise ""

		isImpliedTag = false
		if upper(obj.nameOf()) in IMPLIED_EMPTY_TAGS:
			isImpliedTag = true
		ClientBase.nonEmptyTag(self, obj)
		if obj.nameOf() == "SCRIPT":
			#print "Setting a text trap for script tag"
			self.curr_tag = obj
			return

		self.add(obj)		
		if isImpliedTag == true:
			ClientBase.emptyTag(self,obj)			


	def endTag(self, obj):
		# ignore html and body tags
		if upper(obj.nameOf()) in IMPLIED_EMPTY_TAGS:
			return
		ClientBase.endTag(self,obj)	

	def emptyTag(self, obj):
		ClientBase.emptyTag(self, obj)
		self.stack.append(obj)
		self.add(obj)
		del self.stack[ len(self.stack) - 1 ]

	def text(self, obj):
		ClientBase.text(self, obj)
		if self.curr_tag != None:
			self.curr_tag.setText(obj.value())
			#print "prior to add", vars(self.curr_tag)
			self.add( self.curr_tag )
			#print "after add"
			self.curr_tag = None
		self.add(obj)

	# disable error checking
	def endfile(self):
		pass	

if __name__ == '__main__':
	import sys
	c = DocClient()
	x = XMLProcessor(c)
	x.run(sys.argv[1])
 
	g = c.getGrove() 
	g.dump_structure()


