#
# Copyright 1995 Carlos Maltzahn
# 
# Permission to use, copy, modify, distribute, and sell this software
# and its documentation for any purpose is hereby granted without fee,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of Carlos Maltzahn or 
# the University of Colorado not be used in advertising or publicity 
# pertaining to distribution of the software without specific, written 
# prior permission.  Carlos Maltzahn makes no representations about the 
# suitability of this software for any purpose.  It is provided "as is" 
# without express or implied warranty.
# 
# CARLOS MALTZAHN AND THE UNIVERSITY OF COLORADO DISCLAIMS ALL WARRANTIES 
# WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF 
# MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF COLORADO
# BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY 
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
# IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
# OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
# 
# Author:
# 	Carlos Maltzahn
# 	Dept. of Computer Science
# 	Campus Box 430
# 	Univ. of Colorado, Boulder
# 	Boulder, CO 80309
# 
# 	carlosm@cs.colorado.edu
#

# Talk.py:
#
# Talk.py registers a notification request for all Line instances
# and defines a callback function that is called on every notification.
# The callback function prints out the value of the line attribute of 
# the Line instance. In the event loop it uses the select call for accepting
# input from the keyboard or form notifications.

# import various modules that come with the Python distribution
import sys
import string
import pwd
import os
import pickle
import select

# import network interface for Paos clients 
import Client

# import example schema
import ExSchema

# import utilities
import Utilities

# check command arguments
if len(sys.argv) != 3:
  print 'Usage: python Consumer.py <host> <port>'
  sys.exit(1)

def callback():
  # declare conn and buf as globally defined
  global conn, buf, notif_read
  
  # get data from read end of pipe
  data = Utilities.READ(notif_read, 10000)
  if data == '':
    return

  # unserialize data to get notification
  note = pickle.loads(data)

  # unpack notification
  (r_id, obj_list, other_client) = note

  # register object list in note
  conn.register_objs(obj_list)

  # unpack client name which triggered notification
  (other_host, other_pid, other_uid, other_name) = other_client

  # print lines (each line is one object in a notification)
  for line_obj in obj_list:
    print '%s says: %s' % (other_name, line_obj.line)



# create pipe for notifications 
(notif_read, notif_write) = os.pipe()

# create connection to server 
conn = Client.Connection(sys.argv[1], 
			 string.atoi(sys.argv[2]), 
			 pwd.getpwuid(os.getuid())[0],
			 (notif_read, notif_write))

# register notification requests for all lines
req_id = conn.register('Line',[])

while 1:

  # wait on events on stdin or notification pipe input
  (ready_set, _1, _2) = select.select([0, notif_read], [], [])

  if 0 in ready_set:

    # get line from stdin and check whether EOF
    line = sys.stdin.readline()
    if line == '\n' or line == '':
      conn.close()
      break

    # strip newline character
    line = string.strip(line)

    # keyboard input: create new line object 
    line_obj = ExSchema.Line()

    # register new object
    conn.register_objs([line_obj])

    # assign line to object attribute
    line_obj.line = line

    # commit to server
    conn.commit([line_obj])

  if notif_read in ready_set:
    
    # call callback routine
    callback()
