#
# Copyright 1995 Carlos Maltzahn
# 
# Permission to use, copy, modify, distribute, and sell this software
# and its documentation for any purpose is hereby granted without fee,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of Carlos Maltzahn or 
# the University of Colorado not be used in advertising or publicity 
# pertaining to distribution of the software without specific, written 
# prior permission.  Carlos Maltzahn makes no representations about the 
# suitability of this software for any purpose.  It is provided "as is" 
# without express or implied warranty.
# 
# CARLOS MALTZAHN AND THE UNIVERSITY OF COLORADO DISCLAIMS ALL WARRANTIES 
# WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF 
# MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF COLORADO
# BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY 
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
# IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
# OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
# 
# Author:
# 	Carlos Maltzahn
# 	Dept. of Computer Science
# 	Campus Box 430
# 	Univ. of Colorado, Boulder
# 	Boulder, CO 80309
# 
# 	carlosm@cs.colorado.edu
#

# Talk.py:
#
# This file contains the implementation of the producer side of the
# producer/consumer example. 
# 
# Producer.py creates a Line instance for each input line and writes it
# to the database.

# import various modules that come with the Python distribution
import string
import pwd
import os
import sys

# import network interface for Paos clients
import Client

# import the definition of line objects
import ExSchema

# check command arguments
if len(sys.argv) != 3:
  print 'Usage: python Producer.py <host> <port>'
  sys.exit(1)

# create connection to server 
conn = Client.Connection(sys.argv[1], string.atoi(sys.argv[2]), 
			 'producer_of_' + pwd.getpwuid(os.getuid())[0])

# loop, accept input and store to database
while 1:

  # create new Line instance
  line_obj = ExSchema.Line()

  # register instance with object server
  conn.register_objs([line_obj])

  # accept input and assign to line attribute
  line_obj.line = raw_input('-->')

  # write instance to object server
  conn.commit([line_obj])
