#
# Copyright 1995 Carlos Maltzahn
# 
# Permission to use, copy, modify, distribute, and sell this software
# and its documentation for any purpose is hereby granted without fee,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of Carlos Maltzahn or 
# the University of Colorado not be used in advertising or publicity 
# pertaining to distribution of the software without specific, written 
# prior permission.  Carlos Maltzahn makes no representations about the 
# suitability of this software for any purpose.  It is provided "as is" 
# without express or implied warranty.
# 
# CARLOS MALTZAHN AND THE UNIVERSITY OF COLORADO DISCLAIMS ALL WARRANTIES 
# WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF 
# MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF COLORADO
# BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY 
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
# IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
# OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
# 
# Author:
# 	Carlos Maltzahn
# 	Dept. of Computer Science
# 	Campus Box 430
# 	Univ. of Colorado, Boulder
# 	Boulder, CO 80309
# 
# 	carlosm@cs.colorado.edu
#

# Consumer.py:
#
# This file contains the implementation of the consumer side of the 
# producer/consumer example. 
#
# Consumer.py registers a notification request for all Line instances
# and defines a callback function that is called on every notification.
# The callback function prints out the value of the line attribute of 
# the Line instance.

# import various modules that come with the Python distribution
import string
import pwd
import os
import sys
import time

# import network interface for Paos clients
import Client

# check command arguments
if len(sys.argv) != 3:
  print 'Usage: python Consumer.py <host> <port>'
  sys.exit(1)

def callback():
  # declare conn and buf as globally defined
  global conn, buf
  
  # get first notification
  note = conn.get_notification()

  # check whether there is a notification
  # and get all remaining notifications
  while note != None:

    # unpack notification
    (r_id, obj_list, other_client) = note

    # unpack client name which triggered notification
    (other_host, other_pid, other_uid, other_name) = other_client

    # print lines (each line is one object in a notification)
    for line_obj in obj_list:
      print '%s says: %s' % (pwd.getpwuid(other_uid)[0], line_obj.line)

    # get next notifications
    note = conn.get_notification()



# create connection to server 
conn = Client.Connection(sys.argv[1], string.atoi(sys.argv[2]), 
			 'consumer_of_' + pwd.getpwuid(os.getuid())[0],
			 callback)

# register notification requests for all lines
req_id = conn.register('Line',[])

# this loop is interruptable every 0.2s
while 1:
  time.sleep(0.2)
