#
# Copyright 1995 Carlos Maltzahn
# 
# Permission to use, copy, modify, distribute, and sell this software
# and its documentation for any purpose is hereby granted without fee,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of Carlos Maltzahn or 
# the University of Colorado not be used in advertising or publicity 
# pertaining to distribution of the software without specific, written 
# prior permission.  Carlos Maltzahn makes no representations about the 
# suitability of this software for any purpose.  It is provided "as is" 
# without express or implied warranty.
# 
# CARLOS MALTZAHN AND THE UNIVERSITY OF COLORADO DISCLAIMS ALL WARRANTIES 
# WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF 
# MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF COLORADO
# BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY 
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
# IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
# OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
# 
# Author:
# 	Carlos Maltzahn
# 	Dept. of Computer Science
# 	Campus Box 430
# 	Univ. of Colorado, Boulder
# 	Boulder, CO 80309
# 
# 	carlosm@cs.colorado.edu
#

import string
import os
from types import *

def unique_list(list):
  dict = {}
  for e in list:
    dict[e] = ' '
  return dict.keys()

def tup2list(tuple):
  list = []
  for i in range(len(tuple)):
    list.append(tuple[i])
  return list

def obj2db(value):
  if type(value) is InstanceType and hasattr(value, 'db_id'):
    return ('__db', value.db_id)
  else:
    return value

# get the class and all base classes for a given object
class_visited = []
def classes(obj):
  global class_visited
  classes1(obj.__class__)
  ret = class_visited
  class_visited = []
  return ret

def classes1(class_obj):
  global class_visited
  if class_obj not in class_visited:
    class_visited.append(class_obj)
    for base_class in class_obj.__bases__:
      classes1(base_class)
    
# implememts a length oriented send and recv on top of TCP send and recv
def SEND(sock, message):
  return sock.send(`len(message)` + ' ' + message)

def RECV(sock, buf_len):
  recvd_data = sock.recv(20)
  if len(recvd_data) == 0:
    raise EOFError
  msg_len_header_len = string.index(recvd_data, ' ') + 1
  msg_len = string.atoi(recvd_data[0:msg_len_header_len-1])
  while len(recvd_data) < msg_len + msg_len_header_len:
    act_buf_len = msg_len + msg_len_header_len - len(recvd_data)
    recvd_data = recvd_data + sock.recv(act_buf_len)
  return recvd_data[msg_len_header_len:]

# implements a length oriented write and read on top of low-level write and read
def WRITE(fd, message):
  return os.write(fd, `len(message)` + ' ' + message)

def READ(fd, buf_len):
  recvd_data = os.read(fd, 20)
  if len(recvd_data) == 0:
    raise EOFError
  msg_len_header_len = string.index(recvd_data, ' ') + 1
  msg_len = string.atoi(recvd_data[0:msg_len_header_len-1])
  while len(recvd_data) < msg_len + msg_len_header_len:
    act_buf_len = msg_len + msg_len_header_len - len(recvd_data)
    recvd_data = recvd_data + os.read(fd, act_buf_len)
  return recvd_data[msg_len_header_len:]

# complex_map: returns (value, visited.values())
# func is assumed to be a function that always returns a value. 
# If func preserves object identity of mutable objects then func
# is applied only once to every mutable object found in value
# option in {'', 'no_instance'}
#   'no_instance': no recursive calls of complex_map in instance values
complex_map_visited = {}

def complex_map(func, value, option = ''):
  global complex_map_visited

  value = complex_map1(func, value, option)
  ret = (value, complex_map_visited.values())
  complex_map_visited = {}
  return ret

def complex_map1(func, value, option):
  global complex_map_visited

  if type(value) in [ListType, DictType, InstanceType] and\
     complex_map_visited.has_key(id(value)):
    return value
  else:
    if func != None:
      value = func(value)
    if complex_map_visited.has_key(id(value)):
      return value
    complex_map_visited[id(value)] = value
    if type(value) is TupleType:
      def l(x, func=func, option=option):
	return complex_map1(func, x, option)
      value = tuple(map(l, value))
    elif type(value) is ListType:
      for i in range(len(value)):
	value[i] = complex_map1(func, value[i], option)
    elif type(value) is DictType:
      for key in value.keys():
	value[key] = complex_map1(func, value[key], option)
    elif type(value) is InstanceType and option != 'no_instance':
      for key in value.__dict__.keys():
	value.__dict__[key] = complex_map1(func, value.__dict__[key], option)

    return value
      
