#
# Copyright 1995 Carlos Maltzahn
# 
# Permission to use, copy, modify, distribute, and sell this software
# and its documentation for any purpose is hereby granted without fee,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of Carlos Maltzahn or 
# the University of Colorado not be used in advertising or publicity 
# pertaining to distribution of the software without specific, written 
# prior permission.  Carlos Maltzahn makes no representations about the 
# suitability of this software for any purpose.  It is provided "as is" 
# without express or implied warranty.
# 
# CARLOS MALTZAHN AND THE UNIVERSITY OF COLORADO DISCLAIMS ALL WARRANTIES 
# WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF 
# MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF COLORADO
# BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY 
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
# IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
# OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
# 
# Author:
# 	Carlos Maltzahn
# 	Dept. of Computer Science
# 	Campus Box 430
# 	Univ. of Colorado, Boulder
# 	Boulder, CO 80309
# 
# 	carlosm@cs.colorado.edu
#

import sys
import socket
import select
import pickle
import string
from types import *
import traceback
import Store
import Utilities


#from XMLServer import DocHeader, DocImage

if len(sys.argv) not in [2,3]:
  print 'Usage: python Server.py <port> [<database file name>]'
  sys.exit(1)

s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
s.bind('',string.atoi(sys.argv[1]))

s.listen(5)

conn_table = {} # conn -> client
client_table = {} # client -> conn
conn_list = [s]
print 'Server: ready and listening'

while 1:
  (ready_list, x, y) = select.select(conn_list, [], [])
  print "awake!"
  for ready_conn in ready_list:
    if ready_conn is s:
      (conn, address) = s.accept()
      conn_table[conn] = ''
      conn_list.append(conn)
      print 'Server: connection accepted from', address
    else:
      try:
	data = Utilities.RECV(ready_conn, 20000)
	order = pickle.loads(data)
	#print 'Server: order =', order
	conn_table[ready_conn] = order[0]
	client_table[order[0]] = ready_conn

	if order[1] == 'load': 
	  # (<client>,'load','r'|'rw',<class name>|<obj_list>,<property list>)
	  print 'Server: load request from client', order[0], '...'
	  answer = Store.load(order[0], order[2], order[3],order[4])
	  Utilities.SEND(ready_conn, pickle.dumps(answer))
	  print 'Server: answer =', answer

        #Interface to XML Server
        elif order[1] == 'xml':
          import os
	  if os.fork() != 0: 
	    # (<client>,'xml','url')
            import XMLServer
            XMLServer.processURL( ready_conn, order[2] )
            print 'Server: finished processing ',order[2]
            # killing child process 
            sys.exit(0)

        elif order[0] == 'rmcache':
            import XMLServer
            #(client,'rmcache',url)
            answer = XMLServer.rmcache( ready_conn, order[2] )
            Utilities.SEND(ready_conn, pickle.dumps(answer))
            print "Server: replying to rmcache request"

	elif order[1] == 'commit':
	  # (<client>,'commit',<object list>)
	  print 'Server: commit request from client', order[0], '...'
	  (answer, notifications) = Store.commit(order[0], order[2])
	  Utilities.SEND(ready_conn, pickle.dumps(answer))
	  print 'Server: answer =', answer
	  for (r_client, req_id, objs) in notifications:
	    Utilities.SEND(client_table[r_client], 
			   pickle.dumps((req_id, objs, order[0])))
	  print 'Server: notifications =', notifications

	elif order[1] == 'register':
	  # (<client>, 'register', <class name>|<obj_list>,<property list>)
	  print 'Server: register request from client', order[0], '...'
	  answer = Store.register(order[0], order[2], order[3])
	  Utilities.SEND(ready_conn, pickle.dumps(answer))
	  print 'Server: answer =', answer

	elif order[1] == 'unregister':
	  # (<client>, 'unregister', <request_id>)
	  print 'Server: unregister request from client', order[0], '...'
	  answer = Store.unregister(order[0], order[2]) 
	  Utilities.SEND(ready_conn, pickle.dumps(answer))
	  print 'Server: answer =', answer

	elif order[1] == 'lock':
	  # (<client>, 'lock', <db_id list>)
	  print 'Server: lock request from client', order[0], '...'
	  answer = Store.public_lock(order[0], order[2])
	  Utilities.SEND(ready_conn, pickle.dumps(answer))
	  print 'Server: answer =', answer

	elif order[1] == 'get_new_ids':
	  # (<client>, 'get_new_ids', <count>)
	  print 'Server: get_new_ids request from client', order[0], '...'
	  answer = Store.get_new_ids(order[0], order[2])
	  Utilities.SEND(ready_conn, pickle.dumps(answer))
	  print 'Server: answer =', answer

	else:
	  raise ValueError, "unknown request"

      except: 
	# handle all errors in one handler
	if sys.exc_type in [TypeError, ValueError, RuntimeError]:
	  data = pickle.dumps(('error', sys.exc_type, sys.exc_value))
	  Utilities.SEND(ready_conn, data)
	  print "Server:", traceback.print_exc()

	elif sys.exc_type in [EOFError, socket.error]:
	  if sys.exc_type is socket.error and \
	     sys.exc_value[0] not in [32, 54]:
	    raise socket.error, sys.exc_value
	  #print 'Server:', sys.exc_type, sys.exc_value
	  print 'Server: closing connection, deleting locks and requests of',\
		conn_table[ready_conn]
	  ready_conn.close()
	  Store.release_all_locks(conn_table[ready_conn])
	  Store.delete_all_requests(conn_table[ready_conn])
	  if client_table.has_key(conn_table[ready_conn]):
	    del client_table[conn_table[ready_conn]]
	  del conn_table[ready_conn]
	  conn_list.remove(ready_conn)

	else:
	  Store.db.close()
	  raise sys.exc_type, sys.exc_value

