#
# Copyright 1995 Carlos Maltzahn
# 
# Permission to use, copy, modify, distribute, and sell this software
# and its documentation for any purpose is hereby granted without fee,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of Carlos Maltzahn or 
# the University of Colorado not be used in advertising or publicity 
# pertaining to distribution of the software without specific, written 
# prior permission.  Carlos Maltzahn makes no representations about the 
# suitability of this software for any purpose.  It is provided "as is" 
# without express or implied warranty.
# 
# CARLOS MALTZAHN AND THE UNIVERSITY OF COLORADO DISCLAIMS ALL WARRANTIES 
# WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF 
# MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF COLORADO
# BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY 
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
# IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING 
# OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
# 
# Author:
# 	Carlos Maltzahn
# 	Dept. of Computer Science
# 	Campus Box 430
# 	Univ. of Colorado, Boulder
# 	Boulder, CO 80309
# 
# 	carlosm@cs.colorado.edu
#

import time
import copy
import marshal
from types import *
import Utilities


class DBobject:
  def __init__(self):
    # define list of attributes which contain references to other DBobjects
    self.__dict__['_refs'] = []

  def setDeleted(self):
    self._delete = 1

  # install hooks for reading (_read) and writing (_write) attributes
  # (__getattr__) is only called if attribute does not exist)
  def __getattr__(self, name):
    if self.__dict__.has_key('_read'):
      return self._read(self, name)
    else:
      raise AttributeError, name

  def __setattr__(self, name, value):
    if name in self.__dict__['_refs'] and self.__dict__.has_key('_write'):
      self._write(self, name, value)
    else:
      self.__dict__[name] = value

  def __getstate__(self):
    d = copy.copy(self.__dict__)
    if d.has_key('_read'):
      del d['_read']
    if d.has_key('_write'):
      del d['_write']
    if d.has_key('_time_stamp'):
      del d['_time_stamp']
    for attr_name in self.__dict__['_refs']:
      if d.has_key(' '+attr_name):
	d[attr_name] = d[' '+attr_name]
	del d[' '+attr_name]
      if d.has_key(attr_name):
	(d[attr_name], visited) =\
	  Utilities.complex_map(Utilities.obj2db, d[attr_name])
	for elem in visited:
	  if type(elem) is InstanceType:
	    raise ValueError, 'references object without db_id'
    return marshal.dumps(d)

  def __setstate__(self, data):
    d = marshal.loads(data)
    for key in d.keys():
      self.__dict__[key] = d[key]


