"""
Author: David W. Schere, XML toolkit
Copyright (C) 1998 DIDX llc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
02111-1307, USA.

	This is an optimized widl doc object used internally. It allows
	only input and form tags to be processed making it small.

	By looking at the input services variables it matches that
	with a form.
"""
from WIDLDocObject import widlDocObject
from XMLClient import ClientBase
from XMLProcessor import XMLProcessor
from strop import *	

false, true = 0,1

class InputDoc(ClientBase):
	def __init__(self):
		ClientBase.__init__(self)
		self.grove = widlDocObject()
		self.maskEntityByName("input")
		self.maskEntityByName("form")
		self.maskRejectAllThatDontMatch()
		self.index = 0
	def getGrove(self):
		return self.grove
	def add(self, obj):
		self.grove.add(self.index, self.getStack(), obj )
		self.index = self.index + 1
	def nonEmptyTag(self, obj):
		isinput = false
		if upper(obj.nameOf()) == "INPUT":
			isinput = true
		ClientBase.nonEmptyTag(self, obj)
		self.add(obj)
		if isinput == true:
			ClientBase.endTag(self,obj)
	def emptyTag(self, obj):
		ClientBase.emptyTag(obj)
	def endTag(self, obj):
		ClientBase.endTag(self,obj)
	def endfile(self):
		pass

if __name__ == '__main__':
	import sys
	c = InputDoc()
	x  = XMLProcessor(c)
	x.run( sys.argv[1] )
	g = c.getGrove()
#	g.dump_structure()
	print g.FORM[1]
