"""
Author: David W. Schere, XML toolkit
Copyright (C) 1998 DIDX llc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
02111-1307, USA.


	represents the callService command for an embedded script in a widl
	file.


"""
import strop
false,true = 0,1

WIDLMalformed = "APIService.WIDLMalformed"


# converts a simple expression to a regex
# i.e. 
#	dog* to dog.
#	??dog* to [^ ][^ ]dog.
def simple_expr_to_regex(str):
	buf = ""
	valid = true
	for c in str:
		if c == "\\": 
			valid = false
		else:
			if valid == true:
				if c == "*":
					c = "."
				if c == "?":
					c = "[^ ]"
			else:
				valid = true
		buf = buf + c
	return buf

# scrap
"""
	for i in range(0,widl.SERVICE.length()):
		s = widl.SERVICE[i]
		if s == None: break
		if type == "input":
			if strop.upper(s.getinput()) == strop.upper(name):
				return s
		else:
			if strop.upper(s.getoutput()) == strop.upper(name):
				return s
			
	msg = "service tag attribute name=%s not found" % (name)
	raise WIDLMalformed, msg
	
"""
			

def get_service(widl, name):
	for i in range(0,widl.SERVICE.length()):
		s = widl.SERVICE[i]
		if strop.upper(s.getname()) == strop.upper(name):
			return s
				
	msg = "service tag attribute name=%s not found" % (name)
	raise WIDLMalformed, msg


def get_binding(widl, x, servicename):	
	# get the binding tag 		 
	b = widl.BINDING(name=x)
	if b == None:
		msg = "Error in service name=%s, no binding named %s" % (servicename,x) 
		raise WIDLMalformed, msg		
	return b		
	
def get_input_variables(binding, indict):
	vlist = []
	for v in binding.VARIABLE:
		if v == None: break
		n = v.getname()
		if indict.has_key(n):
			v.setvalue(indict[n])
		vlist.append( v )
	return vlist		
			

#*****
# executes the input portion of a service 
def execInput(widl, service, name, indict):
	# get name of input binding
	input = service.getinput()
	# get the binding matching this name
	binding = get_binding(widl, input, name)
	# now get the variables for this binding		
	invars = get_input_variables(binding,indict)

	# we now have the raw information we need to query 
	# a remote server and stuff the output of that query into  
	# a doc object.			
	from query import query
	return query(widl, service, invars)

#*****
# if there is a region defined make a sub tree of the widl document
def filter_doc(doc, binding, outdoc):
	region = None
	# see if we are directed to make a region
	try:
		region = binding.REGION[0]
	except:
		return outdoc
	
	start_text = strop.strip(region.getstart())
	end_text = strop.strip(region.getend())
	
	start = eval(start_text)
	end = eval(end_text)

	return doc.subTree(start,end)

#*****
# test doc object against a set of conditions
def test_conditions(binding, doc, servicename):
	if not hasattr(binding,"CONDITION"):
		return true	

	# start testing coditions
	for i in range(0, binding.CONDITION.length()):
		c = binding.CONDITION[i]
		expr = c.getmatch()
		if expr != "":
			expr = simple_expr_to_regex(expr)
		type = strop.upper(c.gettype())
		ref = c.getreference()
		
		# evaluate reference
		try:
			data = eval(ref)
		except:
			msg = "Error in reference %s, in service %s" % (ref,servicename)
			raise MalformedWIDL, msg
			
		if expr != "":
			x = regex.compile(expr)
			n = x.search(data)
			
			if type == "SUCCESS" and n == -1:
				return false
			if type == "FAILURE" and n != -1:
				return false
	# all conditions met successfully
	return true 	 

#*****
# place document entity values into variables
def evaluate_variables(binding, doc):
	varset= {}
	for i in range(0, binding.VARIABLE.length()):
		v = binding.VARIABLE[i]
		ref = v.getreference()

		try:
			code = compile(strop.strip(ref),"<string>","eval")
			data = eval(code)
		except:	
			msg = "Invalid reference '%s' in variable name='%s'" % (ref,v.getname())
			raise WIDLMalformed, msg		
		varset[ v.getname() ] = data
	return varset
	
	
#*****
# execOutput portion of service
# 	test binding using conditions then fill up variables with data	
def execOutput(widl, outdoc, service, name):
	# get the name of the output service
	output = service.getoutput()
	# get the binding that matches that name
	binding = get_binding(widl,output,name)

	# divide up a region if directed
	outdoc = filter_doc(widl, binding, outdoc)
	# test conditions
	state = test_conditions(binding, outdoc, name)
	
	if state == false: return None
	
	# evaluate variables
	return evaluate_variables(binding, outdoc)		



#*****
# execute
#	Entry routine for this module. Executes a service for an embedded
#	script or some other medium. 
def execute(widl, name, indict):
	service = get_service(widl, name)
	outdoc = execInput(widl,service,name,indict)
	return execOutput(widl, outdoc, service, name)


