#!/usr/bin/python


from DTDClient import *

from window 	import *
from button 	import *
from label  	import *
from dialog 	import *
from textbox 	import *
from connection import *
from notebook 	import *
from tab 	import *
from combobox 	import *
from popup 	import *
from popup_item import *
from separator 	import *
from listbox    import *

import strop

InvalidTag = "qtXMLClient.InvalidTag"
UnhandledTag = "qtXMLClient.UnhandledTag"

TopNode = None

"""
	Creates a tree structure of Qt widgets that represent
	a form created by the xml file. 
"""
class pluginTree:
	def __init__(self):
		self.t = []
		self.curr = 0
		
	def getRoot(self):
		try:
			return self.t[0][0]
		except:
			return None		
		
	def newEntry(self, w):
		if self.curr == len(self.t):
			# if it doesn't exist
			self.t.append( [w] )
		else:
			self.t[ self.curr ].append( w )	
			
	def onNonEmptyTag(self, w):
		self.newEntry( w )
		self.curr = self.curr + 1

	def onEndTag(self):
		self.curr = self.curr - 1
		
	def onEmptyTag(self, w):
		self.newEntry( w )
		
	def getParent(self):
		if self.curr > 0:
			list = self.t[ self.curr-1 ]		
			return list[ len(list) - 1 ]
		else:
			return None	
	
	def push(self, w):
		self.onNonEmptyTag(w)			
			


"""
	xml client that parses an xml file with qt tags.
"""
class qtXMLClient(DTDClient):
	def __init__(self, child=false):
		DTDClient.__init__(self)
		self.table = {}
		self.pt = pluginTree()
		self.nametable = {}
		self.child = child
		self.scope = "qt"

	def load_qtWidgets(self):
		for i in (select(), combobox(), connection(),\
			textbox(),window(),button(),\
			dialog(),label(), notebook(), tab(),\
			popup(), popup_item(), separator(), \
			listbox(), listbox_item() ):
			# hard coded registering
			self.register(i)
		

	# Register a new tag 		
	def register(self, np):
		n = strop.upper(np.nameOf())
		self.table[ n ] = np
		
	# get the parent widget
	def getParent(self):
		return self.pt.getParent()

	# try to match widget
	def match(self, obj):
		n = strop.upper(obj.nameOf())
		if self.table.has_key(n):
			x = self.table[n].clone()
			p = self.getParent()

			# if p is none then we 			
			if p == None:
				x.setTopLevel( self.pt.getRoot() )
			else:	
				w = p.getWidget()
#				print x, "x.setParent", w
				x.setParent( w )
				
			if x.isValid( obj ) == false:
				msg = "Invalid attributes for tag %s" % (obj.nameOf())	 	 				
				raise InvalidTag, msg

			# call plugin 
			x.call( obj, self )

			if x.useText() == true:
				self.textH = x
			return x
		return None
		
	# refers to getting the text of the widget	
	def __getitem__(self, key):
		key = strop.upper(key)
		if self.nametable.has_key( key ):
			x = self.nametable[key]
			return x
		return None
			
	def has_key(self, key):
		return self.nametable.has_key( key )	

	def __setitem__(self, key, text):
		key = strop.upper(key)
		if self.nametable.has_key( key ):
			self.nametable[key].text(text)
		

	# text handler
	def text(self, obj):
		if hasattr(self, "textH"):
			self.textH.texthandler( obj )
			delattr(self,"textH")
		
	def setNameTable(self, obj, x):
		if obj.has_key("name"):
			self.nametable[ strop.upper(obj["name"]) ] = x
			
	def getWidgetByName( self, n ):
		n = strop.upper(n)
		if self.nametable.has_key( n ):
		 	return self.nametable[n]
		return None
			
	# tag handlers 	
	def nonEmptyTag(self, obj):
		DTDClient.nonEmptyTag(self, obj)

		if strop.upper(obj.nameOf()) == strop.upper(self.scope):
			self.load_qtWidgets()
			return
		
		x = self.match(obj)
		if x != None:
			#self.widgetStack.append( x )
			self.pt.onNonEmptyTag( x )
			self.setNameTable(obj,x)
			return
			
		msg = "Unknown tag %s" % (obj.nameOf())
		raise UnhandledTag, msg
				
	def emptyTag(self, obj):
		DTDClient.emptyTag(self, obj)
		x = self.match(obj)
		if x == None:
			msg = "Unknown tag %s" % (obj.nameOf())
			raise UnhandledTag, msg
		self.pt.onEmptyTag( x )
		self.setNameTable(obj,x)
				
	def endTag(self, obj):
		DTDClient.endTag(self, obj)
		#del self.widgetStack[ len(self.widgetStack) - 1 ]
		self.pt.onEndTag()


	def endfile(self):
		global QtApp

		if hasattr(self,"mainwidget"):
			self.mainwidget.show()

		if self.child == false:
#			print "Main widget set"
			QtApp.setMainWidget( self.mainwidget )
			QtApp.execLoop()
	

def ParseQtXMLFile(xmlfile, isChild = false ):
	from XMLProcessor import *
	
	c = qtXMLClient( isChild )
	x = XMLProcessor( c )
	x.run( xmlfile )
		
				

if __name__ == '__main__':
	import sys
	ParseQtXMLFile( sys.argv[1] )
