#ifndef OBJECT
#define OBJECT

#include <Python.h>
#include <qlist.h>
//#include <qobject.h>
#include <qwidget.h>


#ifdef emit
#undef emit
#endif

class Object;

struct Connection
{
  char *signal;
  PyObject *slotowner;
  PyObject *slot;
};


/*DWS

Allow a slot to bind with a timer event.
*/

#define MAX_TIMERNAME 32

struct TimerConn
{
  char *timername;
  int  id; // hidden from user
  PyObject *slotowner;
  PyObject *slot; 	
};


//class Object : public QObject
class Object : public QWidget
{
  Q_OBJECT;
public:
  Object();
  ~Object();

  void connect(char *signal, PyObject *slot, PyObject *slotowner=0);
  void disconnect(PyObject *slot, char *signal = "");
  void emit(char *signal, PyObject *args);

  // allow the user to create his own timer and set the interval
  void timerConnection(char *timername, int interval, PyObject *slot, PyObject *slotowner=0);
  /* if no name then kill all timers */
  void killTimer(char *timername = 0);
  
protected:
  // overload method to respond to timer events
  void timerEvent(QTimerEvent *evt);
  	   
private:
  void slotConnected(Object *from, char *signal, PyObject *slot);
  void slotDisconnect(Object *from, char *signal, PyObject *slot);
  void cleanup();
  
  
  QList< TimerConn > timer_connections;
  QList< Connection > connections;
};

#endif
