#include "TableView.h"
#include <qlistbox.h>

class ListBox : public TableView
{
  Q_OBJECT;
public:
  ListBox(Widget *parent=0, const char *name=0);
  ~ListBox();

  void setFont(const QFont &);
  unsigned int count() const;
  void insertStrList(PyObject *list, int index = -1);
  void insertItem(const char *text, int index = -1);
  void insertItem(const QPixmap &pixmap, int index=-1);
  void inSort(const char *text);
  void removeItem(int index);
  void clear();
  const char *text(int index) const;
  const QPixmap *pixmap(int index) const;
  void changeItem(const char *temp, int index);
  void changeItem(const QPixmap& pixmap, int index);
  bool autoUpdate() const;
  void setAutoUpdate(int u);
  int numItemsVisible() const;
  int currentItem() const;
  void setCurrentItem(int index);
  void centerCurrentItem();
  int topItem() const;
  void setTopItem(int index);
  bool dragSelect() const;
  void setDragSelect(int ds);
  bool autoScroll() const;
  void setAutoScroll(int as);
  bool autoScrollBar() const;
  void setAutoScrollBar(int asb); 
  bool scrollBar() const; 
  void setScrollBar(int sb); 
  bool autoBottomScrollBar() const; 
  void setAutoBottomScrollBar(int absb); 
  bool bottomScrollBar() const;
  void setBottomScrollBar(int sbsb); 
  bool smoothScrolling() const; 
  void setSmoothScrolling(int ss); 
  int itemHeight() const; 
  int itemHeight(int index) const; 
  long maxItemWidth(); 
  void setMultiSelection(int state);

public slots:
  //Signals
  //
  void highlighted (int index); 
  void selected (int index); 

public:
  QListBox *listbox;

  virtual void setWidget(QListBox *lb);
};
