#include "FileDialog.h"
#include <Python.h>
#include <stdlib.h>


static char *NullPath = "";

#include <iostream.h>


const char *ModalFileDialog(
	const char *dirName,
	const char *filter,
	QWidget *parent,
	const char *name
	)
{
	char *x;
    // start at the current working directory and with *.cpp as filter
    QString f = QFileDialog::getOpenFileName( dirName, filter, parent, name );
    if ( !f.isEmpty() ) {
        // the user selected a valid existing file
	return strdup(f);
    } else {
        // the user cancelled the dialog
	return NullPath;
    }
};



const char *FileDialog::path()
{
	if (f == NULL)
		return NullPath;
	return f->dirPath();
};


FileDialog::FileDialog():Object()
{
	f = NULL;	
};

FileDialog::~FileDialog()
{
	if (f != NULL)
		delete f;
};

int FileDialog::left()
{
	return (f != NULL) ? f->x() : 0;
};
	
int FileDialog::top()
{
	return (f != NULL) ? f->y() : 0;
};

int FileDialog::width()
{
	return (f != NULL) ? f->width() : 0;
};
	
int FileDialog::height()
{
	return (f != NULL) ? f->height(): 0;
};



void FileDialog::show()
{
	if (f != NULL)
		f->show();
};

	
void FileDialog::create(const char *dirName, const char *filter=0,
		QWidget *parent, const char *name, bool
		modal)
{
	f = new QFileDialog(dirName, filter, parent, name, modal);
};
	
void FileDialog::create(QWidget *parent, const char *name,
		bool modal)
{
	f = new QFileDialog(parent,name,modal);
};



void FileDialog::setup()
{
	if (f == NULL) return;

	QObject::connect(f,SIGNAL(fileHighlighted()),this,SLOT(fileHighlighted()));
	QObject::connect(f,SIGNAL(fileSelected()),this,SLOT(fileSelected()));
	QObject::connect(f,SIGNAL(dirEntered()),this,SLOT(dirEntered()));
//  Widget::setWidget((QWidget*)f);
};
		
		
		
		
void FileDialog::fileHighlighted(const char *x)
{
  emit("fileHighlighted", PyString_FromString(x));			
};

void FileDialog::fileSelected(const char *x)
{
  emit("fileSelected", PyString_FromString(x));			
};

void FileDialog::dirEntered(const char *x)
{
  emit("dirEntered", PyString_FromString(x));			
};

				
		
				
