"""
Author: David W. Schere, XML toolkit
Copyright (C) 1998 DIDX llc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
02111-1307, USA.


	This is a collection of clients that can be swapped in and out
	of the factory. The main purpose of the client is for validation.
	All implimentation is done though a registry schema, the client
	is there as a middle mad processing Entity objects from the
	XMLFactory. 
"""

Unexpected = "XMLClient.Client"
XPointerErr = "XMLClient.XPointerClient"
FoundTarget = "XMLClient.FoundTarget"
TargetNotFound = "XMLClient.TargetNotFound"

from XMLFactory import Association, Symbol, Literal, Number, Expr, true, false

import strop



# base class for all client classes, receives entity object from factory 
# and process them.
class ClientBase:		
	def __init__(self):
		self.stack = []
		self._texthandler = []
		self.abortFlag = false
		self.entityMask = []
		self.entityNameMask = []
		# if true reject any object that is referrenced in a
		# mask, else pass any object that is referenced in a mask
		# and reject the ones that match
		self.reject = true 
	def getStack(self):
		return self.stack
		
	def stackLevel(self):
		return len(self.stack)		
		
	def print_stack(self):
		print "stack -> ",
		for obj in self.stack:
			print obj.nameOf(),"::",
		print ""

	def setAbort(self):
		self.abortFlag = true
		
	def abortProcess(self):
		return self.abortFlag			

	def maskEntityByClass(self, obj):
		self.entityMask.append( obj.__class__ )
	def maskEntityByName(self, name):
#		self.entityNameMask.append( obj.nameOf() )
		self.entityNameMask.append( strop.upper(name) )
	# default mode
	def maskRejectAllThatMatch(self):
		self.reject = true
	def maskRejectAllThatDontMatch(self):
		self.reject = false

	def _doCanProcess(self, obj):
		if obj.__class__ in self.entityMask: return false
		if obj.nameOf() == None: return true		

		n = strop.upper(obj.nameOf())
		if n != None:
			if n in self.entityNameMask:
				return false
		return true

	# called by XMLFactory to see whether or not it can process an
	# entitity
	def canProcess(self, obj):
		p = self._doCanProcess(obj)
		if self.reject == false:
			if p == true:
				p = false
			else:
				p = true
		return p
		 

	def setTextHandler(self, func):
		self._texthandler.append( func )
	def text(self, obj):
		s = len(self._texthandler)
		if s > 0:
			func = self._texthandler[s-1]
			func(obj)
			del self._texthandler[s-1]	

	def chars(self, ch):
		pass

	def pi(self, obj):
		pass	
	def emptyTag(self, obj):
		pass
	def nonEmptyTag(self, obj):
		self.stack.append(obj)
	def endTag(self, obj):
		if len(self.stack) == 0:
			print "name = ", obj.nameOf()
			raise Unexpected, "Unexpected end tag, stack is empty"
	#	del self.stack[ len(self.stack) - 1 ]
		self.stack = self.stack[0:len(self.stack)-1]
	def dtd(self, obj):
		pass
	def CDATA(self, obj):
		try:
			x = compile(obj.value(), "<string>", "exec")
			exec(x)
		except:
			raise Unexpected, "Unable to execute code data"
	def comment(self, obj):
		pass
	def endfile(self):
		if len(self.stack) > 0:
			raise Unexpected, "Nonempty tag without endtag unexpected end of file"
		

#****
# html files have special nonEmptyTags that behave like emptyTags
# these are input, hr, p, br.
class htmlClientBase(ClientBase):
	def __init__(self):
		ClientBase.__init__(self)
	def nonEmptyTag(self, obj):
		if strop.upper(obj.nameOf()) in ("INPUT","HR","P","BR"):
			ClientBase.emptyTag(self, obj)
		else:
			ClientBase.nonEmptyTag(self, obj)	
	def endfile(self):
		pass

		
"""
 A special client for use in resolving an XPointer
Give me the tag object within a url by its 
 	<key                                                 
	name=<key>
	text before said tag
	text after tag

	
I want to find the first <table> tag in the document at http://www.ggg.com

x = XPointerClient("tagname","http://www.ggg.com", "table, tr, ... ")

I want the the first tag with the attribute name and its value is "command"
x = XPointerClient("attribute","http://www.ggg.com","name=command")

"""
class XPointerClient(ClientBase):
	def endfile(self):
		ClientBase.endfile(self)
		if self.target == None:
			raise TargetNotFound

	def text(self, obj):
		if self.trap_next_text == true:
			self.target = obj
			raise FoundTarget

	def _tagid(self, tag):
		if self.symbol.value() == tag.nameOf():
			self.nummatches = self.nummatches - 1
			if self.nummatches <= 0:
				if self.command == "textafter_tagid":
					self.trap_next_text = t
				else:
					self.target = tag
					raise FoundTarget

	def _attribute(self, tag):
		attrlist = tag.value()
		for a in attrlist:
			if a.typeOf() == Association().typeOf():
				if a.nameOf() == self.assoc.nameOf() and a.value() == self.assoc.value():
					self.nummatches = self.nummatches - 1
					if self.nummatches == 0:
						if self.command == "textafter_attribute":
							self.trap_next_text = true
						else:
							self.target = tag				
							raise FoundTarget
				
					
	def __init__(self, command, pattern, nummatches = 1):
		ClientBase.__init__(self)
		self.command = command
		self.pattern = pattern
		self.nummatches = nummatches
		self.trap_next_text = false
		self.textafter = ""
		self.target = None		

		if self.command in ("attribute", "textafter_attribute"):
			self.assoc = Association()
			p = self.assoc.process(self.pattern)
			if p == self.pattern:
				raise XPointerErr, "Pattern %s is bogus" % (self.pattern)			
			self.cb = self._attribute
		elif self.command in ("tagid", "textafter_tagid"):
			self.symbol = Symbol()			
			p = self.symbol.process(self.pattern)
			if p == self.pattern:
				raise XPointerErr, "Invalid tag id %s" % (self.pattern) 
			self.cb = self._tagid
		else:
			raise XPointerErr, "Unknown command %s" % (self.command) 				

	def emptyTag(self, obj):
		self.cb( obj )
	def nonEmptyTag(self, obj):
		ClientBase.nonEmptyTag(self, obj)
		self.cb( obj )






"""
	Stuff that doesn't belong in ClientBase but will recieve a new home
	sometime soon.

	def python(self, obj):
		text = obj.value()
		x = compile(text, "<string>", "exec")
		exec(x)
		
		for line in strop.splitfields(text,"\n"):
			if line[:4] == "def ":
				t = strop.find(line,"(")
				funcname = line[4:t]
				cmd = "self._%s = %s" % (funcname, funcname)
				exec(cmd)
		

	def nonEmptyTag(self, obj):
		if obj.nameOf() == "PYTHON":
			self.setTextHandler( self.python )
		# in html there are tags which should end with /> but don't
		implied_endtags = ("p","br")
		if obj.nameOf() in implied_endtags:
			self.emptyTag(obj)
		else:
			self.stack.append(obj)


"""


