#!/usr/bin/python

"""	An xml client with dtd support.
	I only intend to support the
	
	<!DOCTYPE (tag name) system (path for *.dtd)>

	syntax.
"""

from XMLProcessor import *
from XMLFactory import *
from XMLClient import *
from strop import *

ChildTagNotAllowed = "DTDClient.ChildtagNotAllowed"
TooManyReferences  = "DTDClient.TooManyReferences"
InternalError 	   = "DTDClient.InternalError"
InvalidAttribute   = "DTDClient.InvalidAttribute"
MissingRequired    = "DTDClient.MissingRequired"
TypeMisMatch	   = "DTDClient.TypeMismatch"
InvalidTag	   = "DTDClient.InvalidTag"


"""
	Represents the possible values of an attribute.
	It is created by a dtd and used as a reference 
	to determine if an attribute is valid
"""
class attribute_guide:

	def test_required(self, v):
		if v.__class__ == Symbol().__class__:
			if upper(v.value()) == "#REQUIRED":
				return true
		return false	
		
	def __init__(self, n, t, v):
		self.n = n
		self.posVal = [] # possible values
		self.required = false
		self.default = None

		self.required = self.test_required(v)
		if self.required == false:
			# value for attribute if not present
			self.default = v.value()	
		
		if t.__class__ == Expr().__class__:
			for a in t.attr:
				self.posVal.append(a.value())
		else:
			self.dataType = t.value()			
						
		
	
# represents a tag name and its allowable siblings.
class tagElement:
	def __init__(self, n, s):
		self.attr = {}
		self.n = n.value()
		self.siblings = {}
		if Expr().__class__ == s.__class__:
			for a in s.attr:
				self.siblings[upper(a.value())] = \
					(a.getModifier(), 0)
		else:
			n = upper(s.value())
			if n == "#EMPTY":
				self.empty = true
				return
			else:
				self.siblings[n]=(None,0)
				
		self.empty = false
				
	def addAttr(self, n, t, v):
		self.attr[upper(n)] = attribute_guide(n,t,v)		

	def checkAgainstDefaultValues(self, ag, n, obj):
		if len(ag.posVal) > 0:
			val = obj[n]
			if val not in ag.posVal:
				msg = """"
Illegal value for attribute %s
value given was %s
set of possible values is %s
In tag name %s 
"""
				msg = Msg % (n,val,str(ag.posval),obj.nameOf())
				raise InvalidTag, msg			
		
	
	# checks the attributes of this element against an entity object.
	# 1) Validates the existance of MANDITORY attributes
	# 2) If attributes have set values, validates that the
	#    value is one of these	 
	# 3) If an optional attribute has a default value and no
	#    such attribute exists then a default value is injected into
	#    the object.
	def attribute_check(self, obj):
		for (n,ag) in self.attr.items():
			# see if this attribute is manditory ...
			if ag.required == true:
				# then obj must have this attribute ...
				if obj.has_key(n) == false:
					msg = "Manditory attribute %s missing from tag %s"
					msg=msg%(n,obj.nameOf())
					raise InvalidTag, msg
				self.checkAgainstDefaultValues(ag, n, obj)
				continue
				
			# if we get here we are an optional value
			if obj.has_key(n) == true:
				# if there is a list of possible values then check the attribute
				# against this list.
				self.checkAgainstDefaultValues(ag, n, obj)
			else:
				# assign default value if there is one
				if ag.default != None:
					a = Association()
					a.name = n
					a.setValue = ag.default
			
		 
		
	# called when this element is referenced as a parent of
	# another element. It will determine if the tag can be sibling
	# of this tag.
	def sibling_check(self, obj):
		if self.empty == true:
			msg = self.n+" is an empty tag, no child tags allowed"
			raise InvalidTag, msg
	
		n = upper(obj.nameOf())
		if self.siblings.has_key( n ) == false:
			msg = "Tag named %s cannot be a sibling of tag %s" \
				% (self.n, n)
			print self.siblings.keys()
			raise InvalidTag, msg
			
		(m, refcnt) = self.siblings[n]
		if m != None:
			refcnt = refcnt + 1
			
	def endTag(self):		
		for (n,(m,refcnt)) in self.siblings.items():
		  if m != None:
		    if m == "+" and refcnt == 0:
		      msg = """"
Tag %s must have been referenced at least once within the 
scope of tag %s
"""
		      msg = msg % (n,self.n)
		      raise InvalidTag, msg

										
	def nameOf(self):
		return self.n


"""
	validationTable -
		
"""
class validationTable:
	def __init__(self):
		self.elements = {}
		self.stack = []
		
	def emptyTag_check(self, obj):
		# see if element exists
		n=upper(obj.nameOf())
		if self.elements.has_key( n ) == false:
			msg = "Tag name %s is not part of this document's dtd"
			msg=msg%(obj.nameOf())
			raise InvalidTag, msg

		e = self.elements[n]	
		# first check against parents sibling list
		if len(self.stack) > 0:
			# p is the parent of e
			p = self.stack[len(self.stack)-1]
			# see if this tag is eligible to be a child tag of e
			p.sibling_check( obj )
		# see if the attribute is correct
		e.attribute_check( obj )
		return e
		
	def nonEmptyTag_check(self, obj):
		e = self.emptyTag_check(obj)
		self.stack.append( e )
			
		
				
	def endTag_check(self):
		# see if the reference counts are good
		e = self.stack[ len(self.stack)-1 ]
		e.endTag()			
		# ok .. delete from the stack
		del self.stack[ len(self.stack)-1 ]
		
		
	def element(self, obj):
		t = tagElement(obj.attr[1], obj.attr[2])
		self.elements[ upper(t.nameOf()) ] = t

	def attlist(self, obj):
		elmName = upper(obj.attr[1].value())		
		
		list = obj.attr[2:]
		while len(list) > 0:
			n = list[0].value()
			t = list[1]
			v = list[2]
			
			# add a new attribute for this tag
			self.elements[elmName].addAttr(n,t,v)
			list = list[3:]			
				
			

"""
	A client of an XML Processor which supports dtd's for validation
	checking.
"""
class DTDClient(ClientBase):
	def __init__(self):
		ClientBase.__init__(self)
		self.inside_dtd = false
		
		# a tree like reference structure that is associated 
		# with a tag
		self.vt = {}
		# activated when we are inside the scope of a validationTable
		self.cvt = []
		
		# stack of vt tables that determines which dtd
		# has scope. We could have embedded dtds.
		self.vtScope = []
		
		# used only by a parent client for 
		# storage of a dtd validation table
		self.tempVT = validationTable()

	def dump(self, obj):
		for a in obj.attr:
			if Expr().__class__ == a.__class__:
				for a1 in obj.attr:
					print "   ", a1.value()
			print a.value()
		print "------------------"	
		
	def element(self, obj):
		# adds a new element
		self.tempVT.element( obj )

	def attlist(self, obj):
		self.tempVT.attlist( obj )
		
			
	def doctype(self, obj):
#		print "processing doctype"
		temp = DTDClient()
		temp.inside_dtd = true
		x = XMLProcessor( temp )		
		
		# the name of the tag associated with the dtd
		tagname, path = obj.attr[1].value(), \
			obj.attr[2].value()
		# setup a new table
		x.run( path )
#		print temp.tempVT.elements
		
		# associate with a tag	
		self.vt[ upper(tagname) ]  = temp.tempVT	

	def dtd(self, obj):
		n = upper(obj.nameOf())
		if   n == "ELEMENT":
			self.element( obj )
		elif n == "ATTLIST":
			self.attlist( obj )
		elif n == "DOCTYPE":
			self.doctype( obj )
			
	# triggers the act of pushing a new validation
	# table onto the stack.		
	def vt_trigger(self, obj):
		n = upper(obj.nameOf())
		if self.vt.has_key( n ):
			self.cvt.append( (n,self.vt[n]) )
			return true
		return false

	# gets the topmost validation table
	def current_vt(self):
		if len(self.cvt) == 0: return None
		return self.cvt[ len(self.cvt) - 1 ]

	# do the validation of a tag
	def handle_validation( self, obj ):
		if self.inside_dtd == false:
			self.vt_trigger( obj )			
			x = self.current_vt()
			if x == None: return None
			return x[1]		
#			return self.current_vt()[1]
		return None	
			

	def nonEmptyTag(self, obj):
		ClientBase.nonEmptyTag( self, obj )
		vt = self.handle_validation(obj)	
		if vt == None: return
		vt.nonEmptyTag_check( obj )
		
	def emptyTag(self, obj):
		ClientBase.emptyTag( self, obj )
		vt = self.handle_validation(obj)	
		if vt == None: return
		vt.emptyTag_check( obj )
		
	def endTag(self, obj):
		ClientBase.endTag( self, obj )
		vt = self.handle_validation(obj)	
		if vt == None: return
		vt.endTag_check()
			
								


if __name__ == "__main__":
	import sys
	
	filename = sys.argv[1]
	
	c = DTDClient()
	x = XMLProcessor( c )
	x.run( filename )
	














