# Makefile for kconv for Solaris 2.x
# sln 10/28/96
# updated 2/10/97

CC= 		gcc
AR=		ar
LD=		ld

PYTHONTOP= 	/usr/local/src/lang/Python-1.4

DEFS= 		-DHAVE_CONFIG_H

CFLAGS= 	-I$(PYTHONTOP) -I$(PYTHONTOP)/Include $(DEFS)

NKF=		nkf.o
KCONV=		Kconv.o
DYN_TARGET=	kconv.so
STA_TARGET=	kconv.o


dynamic:	$(DYN_TARGET)

$(DYN_TARGET):	$& $(NKF) $(KCONV)
	  	$(LD) -o kconv.so -G src/nkf.o src/Kconv.o

static:		$(STA_TARGET)

$(STA_TARGET):  $& $(NKF)
		$(AR) rcv libkconv.a src/nkf.o; \
                cp src/Kconv.c ./

clean:
		cd src; \
		rm -f *.o
		rm -f *.o *.so *.a *.c

nkf.o:		
		cd src; \
		$(CC) -c nkf.c

Kconv.o:
		cd src; \
		$(CC) -c $(CFLAGS) Kconv.c

