#!/usr/local/bin/python
# File: xlator.py
# Desc: Field and Table classes in python with various translators
# Date: Jan 15, 1998
# Auth: Jim Knight (c)1998 Digital Artisans Inc.
# Mail: jimbag@kw.igs.net
#  RCS: $Id:$
# NOTE:
# TODO:
# History:
# --------
# $Log:$
# -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

from db import *

# ========================================================================
# Sorry this is so long but I figured I'd create the data file from here
# to illustrate assigning values to fields and so it would be self
# contained, with a useful amount of data.

# the name of our data file
datafile = 'baseball.dat'
# define a table for baseball teams
tbl = Table( "Teams" )
tbl.addField( Field( 'Team', width=10 ))
tbl.addField( Field( 'City', width=20 ))
tbl.addField( Field( 'League', width=1 ))
tbl.addField( Field( 'Division', width=1 ))
# a couple of numeric type fields. This causes the CSV code to
# not use quotes and the FIXED code to zero fill. Note that
# the value is still a string internally and when we assign.
tbl.addField( FieldInt( 'Win', width=3 ))
tbl.addField( FieldInt( 'Lose', width=3 ))
# this field is variable length (0) and therefore the
# value is not truncated. Doesn't make sense in a delimited file
# unless it is the last field in the row
tbl.addField( Field( 'Manager' )) 

# now we crank open a file so we can populate it with data
fileout = open( datafile, 'w' )

# these are 1991 stats and 1992 managers 
# just so you bb purists know ;)
# NL East
tbl['Team'] = 'Cubs'
tbl['City'] = 'Chicago'
tbl['League'] = 'N'
tbl['Division'] = 'E'
tbl['Win'] = '21'
tbl['Lose'] = '20'
tbl['Manager'] = 'Jim Lefebvre' 
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Expos'
tbl['City'] = 'Montreal'
tbl['League'] = 'N'
tbl['Division'] = 'E'
tbl['Win'] = '71'
tbl['Lose'] = '90'
tbl['Manager'] = 'Tom Runnels'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Mets'
tbl['City'] = 'New York'
tbl['League'] = 'N'
tbl['Division'] = 'E'
tbl['Win'] = '77'
tbl['Lose'] = '84'
tbl['Manager'] = 'Jeff Torburg'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Phillies'
tbl['City'] = 'Philadelphia'
tbl['League'] = 'N'
tbl['Division'] = 'E'
tbl['Win'] = '78'
tbl['Lose'] = '84'
tbl['Manager'] = 'Jim Fergosi'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Pirates'
tbl['City'] = 'Pittsburg'
tbl['League'] = 'N'
tbl['Division'] = 'E'
tbl['Win'] = '98'
tbl['Lose'] = '64'
tbl['Manager'] = 'Jim Leyland'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Cardinals'
tbl['City'] = 'St. Louis'
tbl['League'] = 'N'
tbl['Division'] = 'E'
tbl['Win'] = '84'
tbl['Lose'] = '78'
tbl['Manager'] = 'Joe Torre'
fileout.write( tbl.write_delim() + '\n' )
# NL West
tbl['Team'] = 'Braves'
tbl['City'] = 'Atlanta'
tbl['League'] = 'N'
tbl['Division'] = 'W'
tbl['Win'] = '94'
tbl['Lose'] = '68'
tbl['Manager'] = 'Bobby Cox'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Reds'
tbl['City'] = 'Cincinnati'
tbl['League'] = 'N'
tbl['Division'] = 'W'
tbl['Win'] = '74'
tbl['Lose'] = '88'
tbl['Manager'] = 'Lou Piniella'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Astros'
tbl['City'] = 'Houston'
tbl['League'] = 'N'
tbl['Division'] = 'W'
tbl['Win'] = '65'
tbl['Lose'] = '97'
tbl['Manager'] = 'Art Howe'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Dodgers'
tbl['City'] = 'Los Angeles'
tbl['League'] = 'N'
tbl['Division'] = 'W'
tbl['Win'] = '93'
tbl['Lose'] = '69'
tbl['Manager'] = 'Tom Lasorda'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Padres'
tbl['City'] = 'San Diego'
tbl['League'] = 'N'
tbl['Division'] = 'W'
tbl['Win'] = '84'
tbl['Lose'] = '78'
tbl['Manager'] = 'Greg Riddoch'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Giants'
tbl['City'] = 'San Francisco'
tbl['League'] = 'N'
tbl['Division'] = 'W'
tbl['Win'] = '75'
tbl['Lose'] = '87'
tbl['Manager'] = 'Roger Craig'
fileout.write( tbl.write_delim() + '\n' )

# AL East
tbl['Team'] = 'Orioles'
tbl['City'] = 'Baltimore'
tbl['League'] = 'A'
tbl['Division'] = 'E'
tbl['Win'] = '67'
tbl['Lose'] = '95'
tbl['Manager'] = 'John Oates'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Red Sox'
tbl['City'] = 'Boston'
tbl['League'] = 'A'
tbl['Division'] = 'E'
tbl['Win'] = '84'
tbl['Lose'] = '78'
tbl['Manager'] = 'Butch Hobson'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Indians'
tbl['City'] = 'Cleveland'
tbl['League'] = 'A'
tbl['Division'] = 'E'
tbl['Win'] = '57'
tbl['Lose'] = '105'
tbl['Manager'] = 'Mike Hargrove'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Tigers'
tbl['City'] = 'Detroit'
tbl['League'] = 'A'
tbl['Division'] = 'E'
tbl['Win'] = '84'
tbl['Lose'] = '78'
tbl['Manager'] = 'Sparky Anderson'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Brewers'
tbl['City'] = 'Milwaukee'
tbl['League'] = 'A'
tbl['Division'] = 'E'
tbl['Win'] = '83'
tbl['Lose'] = '79'
tbl['Manager'] = 'Phil Garner'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Yankees'
tbl['City'] = 'New York'
tbl['League'] = 'A'
tbl['Division'] = 'E'
tbl['Win'] = '71'
tbl['Lose'] = '91'
tbl['Manager'] = 'Buck Showalter'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Blue Jays'
tbl['City'] = 'Toronto'
tbl['League'] = 'A'
tbl['Division'] = 'E'
tbl['Win'] = '91'
tbl['Lose'] = '71'
tbl['Manager'] = 'Cito Gaston'
fileout.write( tbl.write_delim() + '\n' )

# AL West
tbl['Team'] = 'Angels'
tbl['City'] = 'California'
tbl['League'] = 'A'
tbl['Division'] = 'W'
tbl['Win'] = '81'
tbl['Lose'] = '81'
tbl['Manager'] = 'Buck Rodgers'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'White Sox'
tbl['City'] = 'Chicago'
tbl['League'] = 'A'
tbl['Division'] = 'W'
tbl['Win'] = '87'
tbl['Lose'] = '75'
tbl['Manager'] = 'Gene Lamont'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Royals'
tbl['City'] = 'Kansas City'
tbl['League'] = 'A'
tbl['Division'] = 'W'
tbl['Win'] = '82'
tbl['Lose'] = '80'
tbl['Manager'] = 'Hal McRae'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Twins'
tbl['City'] = 'Minnesota'
tbl['League'] = 'A'
tbl['Division'] = 'W'
tbl['Win'] = '95'
tbl['Lose'] = '67'
tbl['Manager'] = 'Tom Kelly'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Athletics'
tbl['City'] = 'Oakland'
tbl['League'] = 'A'
tbl['Division'] = 'W'
tbl['Win'] = '84'
tbl['Lose'] = '78'
tbl['Manager'] = 'Tony La Russa'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Mariners'
tbl['City'] = 'Seattle'
tbl['League'] = 'A'
tbl['Division'] = 'W'
tbl['Win'] = '83'
tbl['Lose'] = '79'
tbl['Manager'] = 'Bill Plummer'
fileout.write( tbl.write_delim() + '\n' )

tbl['Team'] = 'Rangers'
tbl['City'] = 'Texas'
tbl['League'] = 'A'
tbl['Division'] = 'W'
tbl['Win'] = '85'
tbl['Lose'] = '77'
tbl['Manager'] = 'Bobby Valentine'
fileout.write( tbl.write_delim() + '\n' )

# close the file
fileout.close()
# print the table as it now stands
print tbl

# re-read in the file and do some messin' around
filein = open( datafile, 'r' )
while 1:
    # rip the trailing newline
    line = string.rstrip( filein.readline() )
    if not line:
	break
    tbl.read_delim( line )
    print 'Line   -> ' + line
    print 'Tabbed -> ' + tbl.write_delim( '\t' )
    # we can ask for certain fields also
    print 'Bar Subset -> ' + tbl.write_delim( '|', ('Team', 'Manager') )
    print 'Fixed  -> ' + tbl.write_fixed()
    print 'CSV    -> ' + tbl.write_csv()
    print 'SQL    -> ' + tbl.create_sqlinsert()
    print 
print    
print 'SQL Schema'
print '----------'
print tbl.create_sqlschema()
