/* orastuff.h
 *
 * Copyright 1994, 1995 Thomas J. Culliton
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  
 * Thomas J. Culliton makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.  By use of this software the user agrees to 
 * indemnify and hold harmless Thomas J. Culliton from any  claims or
 * liability for loss arising out of such use.
 *
 * This is a derivative work based on oratcl.c by Tom Poindexter, Boulder
 * Colorado.  The following copyright also applies.
 */

/* Copyright 1993 Tom Poindexter and U S WEST Advanced Technologies, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  
 * Tom Poindexter and U S WEST make no representations about the suitability 
 * of this software for any purpose.  It is provided "as is" without express or
 * implied warranty.  By use of this software the user agrees to 
 * indemnify and hold harmless Tom Poindexter and U S WEST from any 
 * claims or liability for loss arising out of such use.
 */
 
/* support for version 6 or version 7; if not 7 assume 6  */
#ifndef VERSION7
#ifndef VERSION6
#define VERSION6
#endif
#endif

/* define oracle cursor (and logon) structures */

struct cda_def
{
   short          v2_rc;        /* v2 return code */
   unsigned short ft;    	/* function type */
   unsigned long  rpc;          /* rows processed count */
   unsigned short peo;          /* parse error offset */
   unsigned char  fc;           /* function code */
   unsigned char  fill1;        /* filler  */
   unsigned short rc;           /* v7 return code */
   unsigned char  wrn;          /* warning flags */
   unsigned char  flg;          /* error flags */
   unsigned int   d0;           /* cursor number */
   struct {                     /* rowid structure */
     struct {
        unsigned long   d1;
        unsigned short  d2;
        unsigned char   d3;
        } rd;
     unsigned long  d4;         /* rba of datablock */
     unsigned short d5;         /* sequence number of row in block */
     } rid;
   unsigned int   ose;          /* os dependent error code */
   unsigned char  sysparm[27];  /* private, reserved fill */
};

typedef struct cda_def CDA;
typedef struct cda_def LDA;


/* _ANSI_ARGS_ should be defined by tcl.h; ignore if not defined */
#ifndef _ANSI_ARGS_
#define _ANSI_ARGS_(x) ()
#endif 

/* prototypes for oci function  */

#ifdef VERSION7

/* version 7 has a few extra functions */

int odescr _ANSI_ARGS_((struct cda_def *, int, unsigned long *, short *, char *,
         unsigned long *, unsigned long *, short *, short *, short *));

int oflng _ANSI_ARGS_((struct cda_def *, int, char *, long, int, 
	 unsigned long *, long));

int oparse _ANSI_ARGS_((struct cda_def *, char *, long, int, unsigned long));

#else

/* fake version 7 odescr and oparse */

#define odescr(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10) \
	  odsc(p1,p2,p3,NULL,NULL,p4,p5,p6,p7)

#define oparse(p1,p2,p3,p4,p5)  osql3(p1,p2,(int) p3)

#endif


int obndrv _ANSI_ARGS_((struct cda_def *, char *, int, char *, int, int,
         int, short *, char *, int, int));

int obndrn _ANSI_ARGS_((struct cda_def *, int, char *, int, int,
         int, short *, char *, int, int));

int obreak _ANSI_ARGS_((struct lda_def *));

int ocan _ANSI_ARGS_((struct cda_def *));

int oclose _ANSI_ARGS_((struct cda_def *));

int ocof _ANSI_ARGS_((struct lda_def *));

int ocom _ANSI_ARGS_((struct lda_def *));

int ocon _ANSI_ARGS_((struct lda_def *));

int odefin _ANSI_ARGS_((struct cda_def *, int, char *, int, int, int, 
	 short *, char *, int, int, unsigned short *, unsigned short *));

int odsc _ANSI_ARGS_((struct cda_def *, int, short *, unsigned short *, short *,
         short *, char *, short *, short *));

int oerhms _ANSI_ARGS_((struct lda_def *, short, char *, int));

int oermsg _ANSI_ARGS_((short, char *));

int oexec _ANSI_ARGS_((struct cda_def *));

int oexn _ANSI_ARGS_((struct cda_def *, int, int));

int ofen _ANSI_ARGS_((struct cda_def *, int));

int ofetch _ANSI_ARGS_((struct cda_def *));

int ologof _ANSI_ARGS_((struct lda_def *));

int olon _ANSI_ARGS_((struct lda_def *, char *, int, char *, int, int));

int oopen _ANSI_ARGS_((struct cda_def *, struct lda_def *, char *, int,
         int, char *, int));

int oopt _ANSI_ARGS_((struct cda_def *, int, int));

int orlon _ANSI_ARGS_((struct lda_def *, char *, char *, int, char *, int));

int orol _ANSI_ARGS_((struct lda_def *));

int osql3 _ANSI_ARGS_((struct cda_def *, char *, int));


/* various limits for arrays of structures, default buffer sizes */
#define ORATCLLDAS      25	/* default number of ldas available */
#define ORATCLCURS      25	/* default number of curs available */
#define ORA_HOST_AREA	256	/* Oracle host data area length */
#define ORA_BUFF_SIZE	4096	/* conversion buffer size for various needs*/
#define ORA_MSG_SIZE	502	/* oracle error message max size*/
#define ORA_CACHE       10      /* number of rows to fetch each time */

/* parse_cols defines */
#define NO_MORE_COLUMNS 1007	/* oracle error code # during odescr */
#define EXT_CHAR_TYPE 1
#define EXT_INT_TYPE 3
#define EXT_FLOAT_TYPE 4
#define EXT_STRING_TYPE 5	/* oracle external data type for string */
#define EXT_LONG_TYPE 8

/* version 7 db / oci 2.0 oparse() has some options */
#define IMMED_PARSE     0 
#define DEFER_PARSE     1
#define DEF_FLAG        DEFER_PARSE	/* defer sending to server */

#define VER6_BEHAVIOR   0
#define NORM_BEHAVIOR   1
#define VER7_BEHAVIOR   2
#define LNG_FLAG        NORM_BEHAVIOR	/* normal treatment of data types */

/* append_cols defines */
#define OUT_OF_SEQUENCE 1002	/* oracle error # fetch out of sequence */
#define NO_DATA_FOUND   1403	/* oracle error # no data for this fetch */
#define NULL_VALUE      1405	/* oracle error # column returned null */
#define COL_TRUNCATED   1406	/* oracle error # column truncated */
#define NUMBER_TYPE     2 	/* oracle internal data type for number */

/* pl exec error */
#define PL_EXEC_ERR     6503	/* oracle error # pl block error */

/* db long column max size */
#ifdef VERSION6
#define MAX_CHAR_SIZE	255		/* v6 */
#define MAX_LONG_SIZE   65535 		/* v6 */
#else
#define MAX_CHAR_SIZE	2000 		/* v7 */
#define MAX_LONG_SIZE   2147483647 	/* v7 */
#endif

#define LONG_BUFF_SIZE  32768   /* chunks to get via oflng() */


struct hda_def {
	char raw[ORA_HOST_AREA];
};

typedef struct hda_def HDA;


/* ColBufs holds information and data of SELECT columns */

struct ColBufs {
    struct ColBufs  *next_buf;	/* pointer to next ColBufs in list */
    short       dbtype;		/* column type */
    char        dbname[256];	/* column name */
#ifdef VERSION7
    unsigned long 
#else
    unsigned short   
#endif
                dbname_len,	/* column name length */
                disp_size,	/* column display size */
                dbsize;		/* column internal size */

    short       prec;		/* precision of numeric */
    short       scale;   	/* scale of numeric */
    short       nullok;         /* if null ok */
/*  long        col_len;        *//* length of column data */
    char       *col_data;       /* pointer to actual column data */
    unsigned short ind[ORA_CACHE];        /* column status indicator */
    unsigned short rlen[ORA_CACHE];       /* actual column length */
    unsigned short rcode[ORA_CACHE];      /* actual column code */
};

typedef struct ColBufs ColBufs;

