#!/usr/local/bin/python

# execsql.py - Read sql statements from stdin and execute them.
#
# Copyright 1994, 1995 Thomas J. Culliton
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  
# Thomas J. Culliton makes no representations about the suitability of
# this software for any purpose.  It is provided "as is" without express
# or implied warranty.  By use of this software the user agrees to 
# indemnify and hold harmless Thomas J. Culliton from any  claims or
# liability for loss arising out of such use.

__doc__ 	= "Reads sql statements from stdin and executes them"

__version__	= "$Revision: 1.2 $"

# A really clever version of this would do be able to do source bindings

from sys import *
import oracle

if len(argv) < 2 :
	print "You must specify a connect string.  e.g. - user/passwd@T:hostname:inst"
	exit(1)

cstr = argv[1]

oracle.maxlong(50000)

con = oracle.logon(cstr)
con.autocommit("on")
cur = con.opencursor()

n = 0
while 1:
	line = stdin.readline()
	if line == "" : break
	n = n + 1
	try :
		cur.execsql(line)
	except oracle.error, msg :
		print "Error on line %d: %s" % (n, line)
		print msg
		break

cur.close()
con.logoff()
