#!/usr/local/bin/python

# db2db.py - Copy the contents of one database to another.
#
# Copyright 1994, 1995 Thomas J. Culliton
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.
# Thomas J. Culliton makes no representations about the suitability of
# this software for any purpose.  It is provided "as is" without express
# or implied warranty.  By use of this software the user agrees to
# indemnify and hold harmless Thomas J. Culliton from any  claims or
# liability for loss arising out of such use.

# Limitations: Dates outside of 1900 - 1999 may cause a problem
# Limitations: Length limit on SQL commands makes copying longs fail

# To Do: Make it copy the database schema as well.
# To Do: Take the config params from the command line.
# To Do: Use source binding to fix the problem with longs
# To Do: Use a more graceful way to choose dumping or executing

__doc__		= "Copy the contents of one database to another."

__version__	= "$Revision: 1.2 $"

from sys import *
from string import *
from regsub import *
import oracle

# ---------- CONFIGURATION PARAMETERS ----------

userid_in = ""
passwd_in = ""
server_in = ""

userid_out = ""
passwd_out = ""
server_out = ""

oracle.maxlong(50000)

dumpsql = 0

# ------------ END OF CONFIGURATION ------------

def build_insert(tablename, row, colnames) :
	ins = "insert into " + tablename + colnames + " values ("
	for i in row :
		if i == None :
			ins = ins + "'',"
		elif type(i) == type('') :
			if find(i, "'") != -1 :
				i = gsub("'","''",i)
			ins = ins + "'" + i + "',"
		else :
			ins = ins + `i` + ","
	ins = ins[0:len(ins)-1] + ")"
	return ins

def copy_tbl(tablename) :
	if not dumpsql : print "Processing ", tablename,

	cur_in = con_in.opencursor()
	if not dumpsql : cur_out = con_out.opencursor()

	cur_in.execsql("select * from " + tablename)

	dsc = cur_in.describe()
	cols = " ("
	for i in dsc :
		cols = cols + i[0] + ","
	cols = cols[0:len(cols)-1] + ") "

	count = 0
	while 1 :
		record = cur_in.fetch()
		if record == None : break
		insert_st = build_insert(tablename, record, cols)
		try :
			if not dumpsql : cur_out.execsql(insert_st)
			if dumpsql : print insert_st
		except oracle.error, msg :
			print "Error on : ", insert_st
			print msg
			exit(1)
		count = count + 1
		if count % 100 == 0 :
			if not dumpsql : con_out.commit()
			if not dumpsql : print ".",
	if not dumpsql : con_out.commit()

	cur_in.close()
	if not dumpsql : cur_out.close()

	if not dumpsql : print " Inserted ", count, " records."


con_in = oracle.logon(userid_in + "/" + passwd_in + server_in)
if not dumpsql : con_out = oracle.logon(userid_in + "/" + passwd_out + server_out)

cur_tblnm = con_in.opencursor()
cur_tblnm.execsql("select table_name from all_tables where owner = '"
	+ upper(userid_in) + "'")
while 1 :
	record = cur_tblnm.fetch()
	if record == None : break
	copy_tbl(record[0])

cur_tblnm.close()

con_in.logoff()
if not dumpsql : con_out.logoff()


