#!/usr/local/bin/python

# SchemaDump.py - Dumps an Oracle database schema like sqlplus does.
#
# Copyright 1994, 1995 Thomas J. Culliton
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  
# Thomas J. Culliton makes no representations about the suitability of
# this software for any purpose.  It is provided "as is" without express
# or implied warranty.  By use of this software the user agrees to 
# indemnify and hold harmless Thomas J. Culliton from any  claims or
# liability for loss arising out of such use.

__doc__ 	= "Dumps an Oracle database schema like sqlplus does"

__version__	= "$Revision: 1.5 $"

from sys import *
from string import *

import oracle

userid = "nobody"
passwd = "nothing"
server = ""

fp = None		# We've only got one of these at a time

zero = (0, None)	# a hack to treat None as zero
blank = ("", None)	# ditto for empty string

oracle.maxlong(10000)	# ALWAYS SET A REASONABLE LIMIT!

con = oracle.logon(userid + "/" + passwd + server)

# This is a bit of useful idiom to do something with each record returned by
# a select statement.  After I block copied and edited the loop three times
# it seemed like a pretty obvious way to do things. ;-)

def each_record(sql_statement, function) :
	cur = con.opencursor()
	cur.execsql(sql_statement)
	while 1 :
		record = cur.fetch()
		if record == None : break
		function(record)
	cur.close()

def dump_tbl(tbl) :
	global fp		# There should be a better way to do this
	fp = open(tbl[0]+".tbl", "w")

	def dump_col(col) :
		global fp	# There should be a better way to do this

		n, t, l, p, s, b = col
		if find(t, "CHAR") != -1 :
			t = "%s(%d)" % (t, l)
		elif t == "NUMBER" and (p not in zero or s not in zero) :
			t = "%s(%d,%d)" % (t, p, s)
		if b != "Y" :
			b = "NOT NULL"
		else :
			b = ""		
		fp.write("%-30.20s %-15.15s %-8.8s\n" % (n, t, b))

	each_record("select column_name, data_type, data_length, "
		"data_precision, data_scale, nullable from all_tab_columns "
		"where owner = '" + upper(userid) +
		"' and table_name = '" + tbl[0] + "' order by column_id",
		dump_col)

	fp.close()

each_record("select table_name from all_tables where owner = '"
	 + upper(userid) + "'", dump_tbl)

def dump_vw(vw) :
	fp = open(vw[0]+".vw", "w")
	fp.write("%s\n" % vw[1])
	fp.close()

each_record("select view_name, text from all_views where owner = '"
	+ upper(userid) + "'", dump_vw)

def dump_seq(seq) :
	fp = open(seq[0]+".seq", "w")
	fp.write("%-30.20s %10d %-30.20s\n" % seq)
	fp.close()

each_record("select sequence_name, min_value, max_value from user_sequences",
	dump_seq)

def dump_idx(idx) :
	fp = open(idx[0]+".idx", "w")
	fp.write("%-30.20s %-15.15s %-8.8s %d\n" % idx)
	fp.close()

each_record("select user_indexes.index_name, uniqueness, column_name, "
	"column_position from user_ind_columns, user_indexes "
	"where user_ind_columns.index_name = user_indexes.index_name",
	dump_idx)

con.logoff()
