
.SUFFIXES:

.SUFFIXES: .c .cpp .obj .hpp .rc .res .man .src .srs


########################
# Default Values:
# ---------------

ENVIRON = OS2

SRCS1 = $(OBJECTS:.obj=.c)

SRCS = $(SRCS1:.\=)

MANPAGES1 = $(HEADERS:.h=.man)

MANPAGES = $(MANPAGES1:.\=)

LIBSLNK=$(LIBS)

#LIBSDEPS=$(LIBS)

!ifndef INCDIR
INCDIR=..\pc\os2\inc
!endif

!ifndef MAKEFILE
MAKEFILE=makefile
!endif

!ifndef LIBDIR
LIBDIR=..\pc\os2\libs
!endif

!ifndef DLLDIR
DLLDIR=..\pc\os2\dll
!endif

# Target Type: DLL or EXE
!ifndef TARGET_TYPE
TARGET_TYPE = EXE
!endif

# Binding: STATIC or DLL
!ifndef BINDING
BINDING = DLL
!endif

# Thread: SINGLE or MULTI
!ifndef THREAD
THREAD = MULTI
!endif

# Build Mode: DEBUG or RELEASE
!ifndef BMODE
BMODE = DEBUG
!endif

# Runtime DLL: ORIG or PROPACK
!ifndef RTDLL
RTDLL = PROPACK
!endif

# Memory debugging: ON or OFF
!ifndef MEM_DEBUG
MEM_DEBUG = OFF
!endif

!ifndef CPPOPTS
CPPOPTS = -Se -Su4 -Q -Tx -Wpro- -DHAVE_CONFIG_H
!endif

!ifndef VCSCFG
VCSCFG = vcs.cfg
!endif

###########################
# Checks:
# -------

!if "$(RTDLL)" == "PROPACK"
!  if "$(THREAD)" == "SINGLE"
!error SINGLE threading is not allowed if using PROPACK Runtime DLL
!  endif
!  if "$(BINDING)" == "STATIC"
!error STATIC binding is not allowed if using PROPACK Runtime DLL
!  endif
!endif


############################
# Tool Settings:
# --------------

CPP           = icc
LIBRARIAN     = ilib
LINKER        = ilink
RC            = rc
RSC						= rsc
CP            = copy
RPL1          = replace
RPL2          = replace
RPLOPT1       = /a
RPLOPT2       = /u
!ifndef FILTER
FILTER        = CPPFilt -b -p -s
!endif
IMPLIB        = implib
MSGBIND       = msgbind
GENMAN        = w:\tools\genman
DEL           = del
RMDIR         = rd
GET           = get
MV            = move
MKDEP         = w:\tools\mkdepend
MORE          = more < 

INIT          = W:\tools

############################
# Flags:
# ------

!if "$(TARGET:.exe=)" == "$(TARGET)"
! if "$(TARGET:.lib=)" == "$(TARGET)"
TARGET_TYPE = DLL
! else
TARGET_TYPE = LIB
! endif
!else
TARGET_TYPE = EXE
!endif




!if "$(TARGET_TYPE)" == "DLL"
ENVOPTS1 = -Ge-
!endif

!if "$(ENVIRON)" == "OS2"
!  if "$(BINDING)" == "DLL"
ENVOPTS2 = -Gd+
!  endif
!  if "$(THREAD)" == "MULTI"
THROPTS= -Gm+
!   if "$(BINDING)" == "DLL"
!    if "$(RTDLL)" == "ORIG"
STDLIB = cppom30i.lib
!    else
STDLIB = pdcrtm10.lib
ENVOPTS3 = -Gn+
!    endif
!   else
STDLIB = cppom30.lib
!   endif
!  else
!   if "$(BINDING)" == "DLL"
STDLIB = cppos30i.lib
!   else
STDLIB = cppos30.lib
!   endif
!  endif
!endif

ALLENVOPTS = $(ENVOPTS) $(ENVOPTS1) $(ENVOPTS2) $(ENVOPTS3)

STDLIB=$(STDLIB) os2386.lib

!if "$(BMODE)" == "DEBUG"
DBGOPT = -DRWDEBUG=1 -Ti
DBGLINK = /DEBUG
!endif

!if "$(MEM_DEBUG)" == "OFF"
MEMOPT =
!else
MEMOPT = -Tm+ -DRW_DONT_USE_MEMORY_POOL
!endif

INCLUDE=.;..;$(INCDIR);$(INCLUDE);..\Include

CPPFLAGS = $(CPPOPTS) $(ADDOPTS) $(ALLENVOPTS) $(THROPTS) $(DEFOPTS) $(DBGOPT) $(MEMOPT)

GENDIR=.\gen.$(ENVIRON)

OBJS = $(OBJECTS:  = )

OBJS0=$(OBJS: =~)
SRCS20=$(SRCS: =~)

OBJS1=$(GENDIR)\$(OBJS0:~.\=~)
SRCS21=.\$(ENVIRON)\$(SRCS20:~.\=~)

!if "$(ENVIRON)" == "OS2"
OBJS2=$(OBJS1:~= .\gen.OS2\)
SRCS22=$(SRCS21:~= .\OS2\)
OBJS3=$(OBJS2:.\gen.OS2\ =)
SRCS23=$(SRCS22:.\OS2\ =)
!endif

GENOBJS=$(OBJS3:\.\=\)
SRCS2=$(SRCS23:\.\=\)


GENTARGET=$(GENDIR)\$(TARGET:.\=)

!if "$(RCFILE)" == ""
!else
RESFILE=$(RCFILE:.rc=.res)
GENRESFILE=$(GENDIR)\$(RESFILE:.\=)
!endif

########################
# Rules:
# ------

.cpp{$(GENDIR)}.obj:
    $(CPP) $(CPPFLAGS) -c -Fo$@ %s


{.\$(ENVIRON)}.cpp{$(GENDIR)}.obj:
    $(CPP) $(CPPFLAGS) -c -Fo$@ %s

.c{$(GENDIR)}.obj:
    $(CPP) $(CPPFLAGS) -c -Fo$@ %s


{.\$(ENVIRON)}.c{$(GENDIR)}.obj:
    $(CPP) $(CPPFLAGS) -c -Fo$@ %s


.hpp.man:
    @echo Generate man page
    $(GENMAN) $*

.rc{$(GENDIR)}.res:
    $(RC) -r $<
    $(MV) $(<:.rc=.res) $(GENDIR)


.opl{$(GENDIR)}.opj:
        ouicomp -C -g -N 5 -d $(OUIDICT) -i pd_std.opl
        echo . > pd_std.OPJ

#####################
# Targets:
# --------


all: $(GENDIR) dispopts $(GENTARGET)

$(GENDIR):
	if not exist $@ md $@

$(GENDIR)\:


dispopts:
  @echo ALLENVOPTS = $(ALLENVOPTS)
  @echo BINDING = $(BINDING)
  @echo BMODE = $(BMODE)
  @echo CPP = $(CPP)
  @echo CPPFLAGS = $(CPPFLAGS)
  @echo CPPOPTS = $(CPPOPTS)
  @echo DBGOPT = $(DBGOPT)
  @echo DEFOPTS = $(DEFOPTS)
  @echo ENVIRON = $(ENVIRON)
  @echo FILTER = $(FILTER)
  @echo GENOBJS = $(GENOBJS)
  @echo GENRESFILE = $(GENRESFILE)
  @echo GENTARGET = $(GENTARGET)
  @echo INCLUDE = $(INCLUDE)
  @echo LIBRARIAN = $(LIBRARIAN)
  @echo LIBSDEPS = $(LIBSDEPS)
  @echo LIBSLNK = $(LIBSLNK)
  @echo LINKER = $(LINKER)
  @echo LNKFLAGS = $(LNKFLAGS)
  @echo MAKEFILE = $(MAKEFILE)
  @echo MEMOPT = $(MEMOPT)
  @echo MODEL = $(MODEL)
  @echo SRCS = $(SRCS)
  @echo STDLIB = $(STDLIB)
  @echo TARGET = $(TARGET)
  @echo TARGET_TYPE = $(TARGET_TYPE)
  @echo THREAD = $(THREAD)
  @echo THROPTS = $(THROPTS)

depend: $(GENDIR)
  echo # Makefile.dep for $(TARGET) > $(GENDIR)\makefile.dep
  echo # >> $(GENDIR)\makefile.dep
#  echo #INCLUDE=$$(ORIGINCLUDE) >> $(GENDIR)\makefile.dep
  $(MKDEP) @<<
  -u -p$(GENDIR)\ -f$(GENDIR)\makefile.dep
  -D__cplusplus -D__IBMCPP__ -D__MULTI__
  -- $(CPPFLAGS) --
  $(SRCS) $(SRCS2)
<<

#  sed "s/^[a-zA-Z0-9]*.obj/.\\gen.$(ENVIRON)\\&/g" $(GENDIR)\makefile.de0 \
#	| sed "s/^.\\$(ENVIRON)\\/.\\gen.$(ENVIRON)\\/g" \
#          > $(GENDIR)\makefile.dep

#  $(MKDEP) -f$(GENDIR)\makefile.de0 -- $(CPPFLAGS) -- $(SRCS) $(SRCS2)
	
man: $(MANPAGES)

get:
  $(GET) -u -c$(VCSCFG) $(SRCS) $(HEADERS:.\=) $(MAKEFILE)

clean:
	- $(DEL) $(GENDIR)\*.obj
	- if exist $(GENDIR)\*.lib $(DEL) $(GENDIR)\*.lib
#  - $(DEL) $(GENDIR)
#  - $(RMDIR) $(GENDIR)


!ifdef LIBS
#$(LIBS): {$(LIB);}$@
#	echo $@ is newer
!endif


!if "$(TARGET_TYPE)" == "DLL"

$(GENTARGET): $(GENOBJS) $(LIBSDEPS) $(GENTARGET:.dll=.def) $(MAKEFILE)
  $(CPP) @<<
 /Tdp /Fm$(GENTARGET:.dll=.map)
 /B"/de /NOE /NOD $(DBGLINK) $(LNKFLAGS)"
 /Fe$(GENTARGET) $(GENTARGET:.dll=.def)
 $(GENOBJS)
 $(LIBSLNK)
 $(STDLIB)
<<
   $(IMPLIB) $(GENTARGET:.dll=.lib) $(GENTARGET:.dll=.def)


$(GENTARGET:.dll=.def): $(GENOBJS)
  $(FILTER) $(GENOBJS) $(ADDFILTS) > $(GENDIR)\filt.def
  $(CP) DefHdr.def+$(GENDIR)\filt.def $@


install: $(GENTARGET)
  - $(RPL1) $(GENDIR)\*.dll $(DLLDIR) $(RPLOPT1)
  - $(RPL2) $(GENDIR)\*.dll $(DLLDIR) $(RPLOPT2)
  - $(RPL1) $(GENDIR)\*.lib $(LIBDIR) $(RPLOPT1)
  - $(RPL2) $(GENDIR)\*.lib $(LIBDIR) $(RPLOPT2)
  - $(RPL1)           *.h*  $(INCDIR) $(RPLOPT1)
  - $(RPL2)           *.h*  $(INCDIR) $(RPLOPT2)


!else
#else: EXE or LIB
! if "$(TARGET_TYPE)" == "EXE"


$(GENTARGET): $(GENOBJS) $(LIBSDEPS) $(DEFFILE) $(GENRESFILE) $(GENDIR)\msgbind.inp $(MAKEFILE)
  $(CPP) @<<
 /Tdp /Fm$(GENTARGET:.exe=.map)
 /B"/de /NOE /NOD $(DBGLINK) $(LNKFLAGS)"
 /Fe$(GENTARGET) $(DEFFILE)
 $(GENOBJS) msgseg.obj
 $(LIBSLNK)
 $(STDLIB)
<<
!if "$(RESFILE:.res=)" == "$(RESFILE)"
!else
  $(RC) $(GENRESFILE) $(GENTARGET)
!endif
  $(MSGBIND) $(GENDIR)\msgbind.inp


$(GENDIR)\msgbind.inp: {$(DPATH);}dde4.msg
  @rem @<<$@
>$(GENTARGET)
<$**
*
<<

! else
#else: LIB

$(GENTARGET): $(GENOBJS) $(LIBSDEPS) $(MAKEFILE)
  if exist $(GENTARGET) $(DEL) /n $(GENTARGET)
  $(LIBRARIAN) $(GENTARGET) $(GENOBJS), $(GENTARGET:.lib=.lst),


install: $(GENTARGET)
  - $(RPL1) $(GENDIR)\*.lib $(LIBDIR) $(RPLOPT1)
  - $(RPL2) $(GENDIR)\*.lib $(LIBDIR) $(RPLOPT2)
  - $(RPL1)           *.h*  $(INCDIR) $(RPLOPT1)
  - $(RPL2)           *.h*  $(INCDIR) $(RPLOPT2)

! endif


!endif



ORIGINCLUDE=$(INCLUDE)

INCLUDE=.;\inc;$(INCLUDE)
!include <gen.OS2\makefile.dep>


