from pg95 import *

# This library file contains some common functions not directly provided by the
# PostGres C library. It offers too a keyword interface for pg95module connect
# function.

# encapsulate pg95 connect function for keywords enabling
def doconnect(host = None, port = None, opt = None, tty = None, dbname = None):
	return connect(host, port, opt, tty, dbname)

# list all databases on the server 
def ListDB(pg95cnx):
	result = pg95cnx.query("select datname from pg_database")
	list = []
	for node in result:
		list.append(result[i][0])
	return list

# list all tables (classes) in the selected database
def ListTables(pg95cnx):
	result = pg95cnx.query("select relname from pg_class "	\
		"where relkind = 'r' "				\
		"  and relname !~ '^Inv' "			\
		"  and relname !~ '^pg_'")
	list = []
	for node in result:
		list.append(node[0])
	return list

# list table fields (attribute) in given table
def ListAllFields(pg95cnx, table):
	result = pg95cnx.query("select c.relname, a.attname, t.typname " \
		"from pg_class c, pg_attribute a, pg_type t "	\
		"where c.relname = '%s' "			\
		"  and a.attnum > 0"				\
		"  and a.attrelid = c.oid"			\
		"  and a.atttypid = t.oid "			\
		"order by relname, attname" % table)
	# personnal preference ... so I leave the original query
	list = []
	for node in result:
		list.append(node[1], node[2])
	return list
