#include "stdafx.h"
#include "app.h"
#include "util.h"

/////////////////////////////////////////////////////////////////////////////
// CWpyFont



CWpyFont::CWpyFont(PyObject *pyfont, char * family, long height, long weight, long oneMeter)
{
	m_nPrintRes = 0;
	m_nPointSize = height;
	theApp.RecordObjects(this, pyfont, FALSE);
	height *= (long)(oneMeter * 0.000352778 + 0.5);	// Convert points to pixels
	BYTE pitch;
	switch(family[0]){
		case 'm':	// modern fixed pitch
			pitch = FF_MODERN + FIXED_PITCH;
			break;
		case 'r':	// Roman
			pitch = FF_ROMAN + VARIABLE_PITCH;
			break;
		case 's':	// Swiss
			pitch = FF_SWISS + VARIABLE_PITCH;
			break;
		default:	// unrecognized, but use variable pitch
			pitch = FF_DONTCARE + VARIABLE_PITCH;
			break;
	}
	BYTE italic;
	if (strstr(family, "italic"))
		italic = 1;
	else
		italic = 0;
	m_nWeight = weight;
	m_bItalic = italic;
	m_bPitch = pitch;
	m_ScreenFont.CreateFont(-height, 0, 0, 0, weight, italic, 0,
		0, 0, 0, 0, PROOF_QUALITY, pitch, NULL);
}

CWpyFont::CWpyFont(PyObject *pyfont, long index)
{
	m_nPrintRes = 0;
	m_nPointSize = 0;
	theApp.RecordObjects(this, pyfont, FALSE);
	m_ScreenFont.CreateStockObject(index);
}

CWpyFont::~CWpyFont()
{
	theApp.UnRecordCpp(this, FALSE);
}

void CWpyFont::SelectFont(CDC * pDC)
{
	if (pDC->IsPrinting()) {
		long res = pDC->GetDeviceCaps(LOGPIXELSX) + pDC->GetDeviceCaps(LOGPIXELSY);
		if (res != m_nPrintRes){		// Make a new font
			m_nPrintRes = res;
			// Convert points to pixels
      			double meter = pDC->GetDeviceCaps(HORZRES) * 1000.0 /
				pDC->GetDeviceCaps(HORZSIZE);
			long height = (long)(m_nPointSize * meter * 0.000352778 + 0.5);
			m_PrintFont.CreateFont(-height, 0, 0, 0,
				m_nWeight, m_bItalic, 0,
				0, 0, 0, 0, PROOF_QUALITY, m_bPitch, NULL);
		}
		pDC->SelectObject(&m_PrintFont);
	}
	else
		pDC->SelectObject(&m_ScreenFont);
}
