// mdichild.cpp : implementation file
//
//Python is Copyright 1991-1997 by Stichting Mathematisch Centrum,
//Amsterdam, The Netherlands.  See their copyright notice.

//This code is copyright 1994-1997 by James C. Ahlstrom.  See the
//copyright notice in "copyrite.jim" or e-mail jim@interet.com.
// NO WARRANTIES AT ALL.  USE AT YOUR OWN RISK.


#include "stdafx.h"
#include "app.h"
#include "mdichild.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWpyMDIChildWnd

IMPLEMENT_DYNCREATE(CWpyMDIChildWnd, CMDIChildWnd)

CWpyMDIChildWnd::CWpyMDIChildWnd()
{
#ifndef NETSCAPE_PI	// We are not in a Netscape Plugin
	PyObject *method = PyObject_GetAttrString(theApp.m_python_template, "wpyFrame");
	if (!method){
		PyErr_SetString(PyExc_NameError, "Bad template");
		return;
	}
	PyObject * pyframe = PyEval_CallObject (method, NULL);
	Py_DECREF(method);
	if (!pyframe || pyframe == Py_None) {
		ASSERT(0);
		AfxMessageBox("Can not create frame");
	}
	else
		theApp.RecordObjects(this, pyframe, TRUE);
#endif
}

CWpyMDIChildWnd::~CWpyMDIChildWnd()
{
	CObject *obj;
	POSITION pos = m_DeleteList.GetHeadPosition();
	while (pos){	// Delete all objects on delete list.
		obj = m_DeleteList.GetNext(pos);
		theApp.UnRecordCpp(obj, TRUE);
		delete obj;
	}
	m_DeleteList.RemoveAll();
	theApp.UnRecordCpp(this, TRUE);
}


BEGIN_MESSAGE_MAP(CWpyMDIChildWnd, CMDIChildWnd)
	//{{AFX_MSG_MAP(CWpyMDIChildWnd)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_WM_KILLFOCUS()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWpyMDIChildWnd message handlers

void CWpyMDIChildWnd::SetDefaultMenu(CMenu * menu) 
{
	m_hMenuShared = menu->GetSafeHmenu();
}

void CWpyMDIChildWnd::OnDestroy() 
{
	CMDIChildWnd::OnDestroy();
	theApp.CallPython(this, "WpyPhysOnDestroy");
}

int CWpyMDIChildWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	PyObject * args = Py_BuildValue("(O)", Py_None);
	theApp.CallPython(this, "OnCreate", args);
	Py_DECREF(args);
	return 0;
}

void CWpyMDIChildWnd::OnSetFocus(CWnd* pOldWnd) 
{
	CMDIChildWnd::OnSetFocus(pOldWnd);
	PyObject * pyobj = theApp.GetPythonObject(pOldWnd);
	if (!pyobj)
		pyobj = Py_None;
	pyobj = Py_BuildValue("(O)", pyobj);
	theApp.CallPython(this, "WpyPhysOnSetFocus", pyobj);
	Py_DECREF(pyobj);
}

void CWpyMDIChildWnd::OnKillFocus(CWnd* pNewWnd) 
{
	CMDIChildWnd::OnKillFocus(pNewWnd);
	PyObject * pyobj = theApp.GetPythonObject(pNewWnd);
	if (!pyobj)
		pyobj = Py_None;
	pyobj = Py_BuildValue("(O)", pyobj);
	theApp.CallPython(this, "WpyPhysOnKillFocus", pyobj);
	Py_DECREF(pyobj);
}

BOOL CWpyMDIChildWnd::PreCreateWindow(CREATESTRUCT& cs) 
{
	long sizex, sizey, x, y;	// Try to set window size
	PyObject * pyframe = theApp.GetPythonObject(this);
	if (!GetAttrLong(pyframe, "wpySizeX", &sizex))
		sizex = 200;
	if (!GetAttrLong(pyframe, "wpySizeY", &sizey))
		sizey = 200;
	if (!GetAttrLong(pyframe, "wpyLocX", &x))
		x = 0;
	if (!GetAttrLong(pyframe, "wpyLocY", &y))
		y = 0;
	if (x > 0 || y > 0) {
		cs.x = x;
		cs.y = y;
	}
	cs.cx = sizex;
	cs.cy = sizey;
	return CMDIChildWnd::PreCreateWindow(cs);
}

void CWpyMDIChildWnd::OnSysCommand(UINT nID, LPARAM lParam) 
{
	PyObject * args = Py_BuildValue("(ii)", nID, lParam);
	PyObject * pyobj = theApp.CallPythonRet(this, "OnSysCommand", args);
	Py_DECREF(args);
	int dodefault = 1;
	if (pyobj){
		if (PyInt_Check(pyobj) && PyInt_AsLong(pyobj) == 0)
			dodefault = 0;
		Py_DECREF(pyobj);
	}
	if ( dodefault)
		CMDIChildWnd::OnSysCommand(nID, lParam);
	//if (nID == SC_CLOSE)
	//	return;
}


BOOL CWpyMDIChildWnd::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	PyObject * attr;
	PyObject * pyobj = theApp.GetPythonObject(this);
	if(pyobj && (attr = PyObject_GetAttrString(pyobj, "OnCreateClient"))) {
		PyObject * v = PyInt_FromLong((long)lpcs);
		PyObject_SetAttrString(pyobj, "wpyphysLpcs", v);
		v = PyInt_FromLong((long)pContext);
		PyObject_SetAttrString(pyobj, "wpyphysPContext", v);
		PyObject * args = Py_BuildValue("(iiii)",(int)lpcs->x,
			(int)lpcs->y, (int)lpcs->cx, (int)lpcs->cy);
		PyObject * pyapp = theApp.GetPythonObject(&theApp);
		PyObject * rect = theApp.CallPythonRet(pyapp, "WpyReturnCRect", args);
		Py_DECREF(args);
		args = Py_BuildValue("(O)", rect);
		int ret = theApp.CallPython(this, "OnCreateClient", args);
		Py_DECREF(rect);
		Py_DECREF(args);
		Py_DECREF(attr);
		return ret;
	}
	else {
		PyErr_Clear();
		return CMDIChildWnd::OnCreateClient(lpcs, pContext);
	}
}

BOOL CWpyMDIChildWnd::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	if (theApp.PyOnCommand(wParam, lParam))
		return TRUE;
	return CMDIChildWnd::OnCommand(wParam, lParam);
}
