#include "stdafx.h"
#include "app.h"
#include "globals.h"
#include "view.h"

int WpyOnChar(CObject * This, UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	PyObject * pyobj = theApp.GetPythonObject(This);
	int flags = 0;
	if (GetKeyState(VK_SHIFT) < 0)
		flags |= MK_SHIFT;
	if (GetKeyState(VK_CONTROL) < 0)
		flags |= MK_CONTROL;
	if (GetKeyState(VK_LBUTTON) < 0)
		flags |= MK_LBUTTON;
	if (GetKeyState(VK_MBUTTON) < 0)
		flags |= MK_MBUTTON;
	if (GetKeyState(VK_RBUTTON) < 0)
		flags |= MK_RBUTTON;
	PyObject *args = Py_BuildValue("(ci)", nChar, flags);
	pyobj = theApp.CallPythonRet(pyobj, "WpyPhysOnChar", args);
	Py_DECREF(args);
	int dodefault = 1;
	if (pyobj){
		if (PyInt_Check(pyobj) && PyInt_AsLong(pyobj) == 0)
			dodefault = 0;
		Py_DECREF(pyobj);
	}
	return dodefault;
}

int WpyOnVChar(CObject * This, UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	char buf8[8];
	char * name = 0;
	int dodefault = 1;
	switch(nChar) {
	case VK_DELETE:
		name = "Delete";
		break;
	case VK_DOWN:
		name = "Down";
		break;
	case VK_END:
		name = "End";
		break;
	case VK_HOME:
		name = "Home";
		break;
	case VK_INSERT:
		name = "Insert";
		break;
	case VK_LEFT:
		name = "Left";
		break;
	case VK_NEXT:
		name = "Next";
		break;
	case VK_PRIOR:
		name = "Prior";
		break;
	case VK_RIGHT:
		name = "Right";
		break;
	case VK_UP:
		name = "Up";
		break;
	default:
		if (nChar >= 0x70 && nChar <= 0x87) {
			name = buf8;
			sprintf(buf8, "F%d", (int)(nChar - 0x6F));
		}
	}
	if (name) {
		PyObject * pyobj = theApp.GetPythonObject(This);
		int flags = 0;
		if (GetKeyState(VK_SHIFT) < 0)
			flags |= MK_SHIFT;
		if (GetKeyState(VK_CONTROL) < 0)
			flags |= MK_CONTROL;
		if (GetKeyState(VK_LBUTTON) < 0)
			flags |= MK_LBUTTON;
		if (GetKeyState(VK_MBUTTON) < 0)
			flags |= MK_MBUTTON;
		if (GetKeyState(VK_RBUTTON) < 0)
			flags |= MK_RBUTTON;
		PyObject *args = Py_BuildValue("(si)", name, flags);
		pyobj = theApp.CallPythonRet(pyobj, "WpyPhysOnVChar", args);
		Py_DECREF(args);
		if (pyobj){
			if (PyInt_Check(pyobj) && PyInt_AsLong(pyobj) == 0)
				dodefault = 0;
			Py_DECREF(pyobj);
		}
	}
	if (nChar == 0x70)	// Help key : F1
		dodefault = 1;
	return dodefault;
}

void WpyMouse(CObject * This, UINT nFlags, CPoint point, char *msg)
{
	PyObject * pythis = theApp.GetPythonObject(This);
	PyObject * args = Py_BuildValue("(iii)", point.x, point.y, nFlags);
	theApp.CallPython(pythis, msg, args);
	Py_DECREF(args);
}

void WpyOnScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	int pos, min, max, page, line;

	if (pScrollBar){	// Message came from a control
		pos = pScrollBar->GetScrollPos();
		pScrollBar->GetScrollRange(&min, &max);
		line = (max - min) / 100;
		page = (max - min) / 10;
		if (line < 1)
			line = 1;
		if (page < 4)
			page = 4;
		switch(nSBCode){
		case SB_LINEDOWN:
			pos += line;
			break;
		case SB_PAGEDOWN:
			pos += page;
			break;
		case SB_LINEUP:
			pos -= line;
			break;
		case SB_PAGEUP:
			pos -= page;
			break;
		case SB_THUMBPOSITION:
		case SB_THUMBTRACK:
			pos = (int) nPos;
			break;
		}
		if (pos > max)
			pos = max;
		if (pos < min)
			pos = min;	
		pScrollBar->SetScrollPos(pos, 1);
		PyObject * ret = Py_BuildValue("(i)", pos);
		theApp.CallPython(pScrollBar, "WpyPhysOnScroll", ret);
		Py_DECREF(ret);
	}
}
