// doc.cpp : implementation of the CWpythonDoc class
//
//Python is Copyright 1991-1997 by Stichting Mathematisch Centrum,
//Amsterdam, The Netherlands.  See their copyright notice.

//This code is copyright 1994-1997 by James C. Ahlstrom.  See the
//copyright notice in "copyrite.jim" or e-mail jim@interet.com.
// NO WARRANTIES AT ALL.  USE AT YOUR OWN RISK.


#include "stdafx.h"
#include "app.h"

#include "doc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWpythonDoc

IMPLEMENT_DYNCREATE(CWpythonDoc, CDocument)

BEGIN_MESSAGE_MAP(CWpythonDoc, CDocument)
	//{{AFX_MSG_MAP(CWpythonDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWpythonDoc construction/destruction

CWpythonDoc::CWpythonDoc()
{
#ifndef NETSCAPE_PI	// We are not in a Netscape Plugin
	PyObject *method = PyObject_GetAttrString(theApp.m_python_template, "wpyDocument");
	if (!method){
		PyErr_SetString(PyExc_NameError, "Bad template");
		return;
	}
	PyObject * pydocument = PyEval_CallObject (method, NULL);
	Py_DECREF(method);
	if (!pydocument || pydocument == Py_None) {
		ASSERT(0);
		AfxMessageBox("Can not create document");
	}
	else
		theApp.RecordObjects(this, pydocument, TRUE);
#endif
}

CWpythonDoc::~CWpythonDoc()
{
	theApp.UnRecordCpp(this, TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// CWpythonDoc serialization

void CWpythonDoc::Serialize(CArchive& ar)
{
}

/////////////////////////////////////////////////////////////////////////////
// CWpythonDoc diagnostics

#ifdef _DEBUG
void CWpythonDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CWpythonDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWpythonDoc commands

BOOL CWpythonDoc::OnNewDocument()
{
	PyObject * ret = theApp.CallPythonRet(this, "OnNewDocument", NULL);
	if (!ret)
		return CDocument::OnNewDocument();
	long iret = 1;
	if (PyInt_Check(ret))
		iret = PyInt_AsLong(ret);
	Py_DECREF(ret);
	if (iret)
		return TRUE;
	return FALSE;
}

BOOL CWpythonDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
	PyObject * args = Py_BuildValue("(s)", lpszPathName);
	PyObject * ret = theApp.CallPythonRet(this, "OnOpenDocument", args);
	Py_DECREF(args);
	if (!ret)
		return FALSE;
	long iret = 1;
	if (PyInt_Check(ret))
		iret = PyInt_AsLong(ret);
	Py_DECREF(ret);
	if (iret)
		return TRUE;
	return FALSE;
}

void CWpythonDoc::DeleteContents() 
{
	theApp.CallPython(this, "DeleteContents");
}

void CWpythonDoc::OnCloseDocument() 
{
	theApp.CallPythonRet(this, "OnCloseDocument", NULL);
}

BOOL CWpythonDoc::OnSaveDocument(LPCTSTR lpszPathName) 
{
	PyObject * args = Py_BuildValue("(s)", lpszPathName);
	PyObject * ret = theApp.CallPythonRet(this, "OnSaveDocument", args);
	Py_DECREF(args);
	if (!ret)
		return FALSE;
	long iret = 1;
	if (PyInt_Check(ret))
		iret = PyInt_AsLong(ret);
	Py_DECREF(ret);
	if (iret)
		return TRUE;
	return FALSE;
}
