// dialog.cpp : implementation file
//
//Python is Copyright 1991-1997 by Stichting Mathematisch Centrum,
//Amsterdam, The Netherlands.  See their copyright notice.

//This code is copyright 1994-1997 by James C. Ahlstrom.  See the
//copyright notice in "copyrite.jim" or e-mail jim@interet.com.
// NO WARRANTIES AT ALL.  USE AT YOUR OWN RISK.


#include "stdafx.h"
#include "app.h"
#include "dialog.h"
#include "globals.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWpythonDialog dialog

IMPLEMENT_DYNCREATE(CWpythonDialog, CDialog)

CWpythonDialog::CWpythonDialog()	// Modeless dialog
	: CDialog()
{
}

CWpythonDialog::CWpythonDialog(CWnd* pParent)	// Modal dialog
	: CDialog(CWpythonDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWpythonDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CWpythonDialog::~CWpythonDialog()
{	//BUG:
	//CObject *obj;
	//POSITION pos = m_DeleteList.GetHeadPosition();
	//while (pos){	// Delete all objects on delete list.
	//	obj = m_DeleteList.GetNext(pos);
	//	theApp.UnRecordCpp(obj, TRUE);
	//	delete obj;
	//}
	//m_DeleteList.RemoveAll();
	//theApp.UnRecordCpp(this, TRUE);	// Remove map to Python object.
}

BOOL CWpythonDialog::Create(UINT id, CWnd * parent = NULL)
{
	return CDialog::Create(id, parent);
}

void CWpythonDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWpythonDialog)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CWpythonDialog, CDialog)
	//{{AFX_MSG_MAP(CWpythonDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWpythonDialog message handlers

BOOL CWpythonDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	PyObject * pydialog = theApp.GetPythonObject(this);
	ASSERT(pydialog);
	char *title;
	if (title = GetAttrString(pydialog, "wpyText"))
		SetWindowText(title);
	long sizex, sizey;
	if (GetAttrLong(pydialog, "wpySizeX", &sizex) &&
			GetAttrLong(pydialog, "wpySizeY", &sizey))
		SetWindowPos(NULL, 0, 0, (int)sizex, (int)sizey, SWP_NOMOVE + SWP_NOZORDER);
	PyObject * ret = theApp.CallPythonRet(this, "OnInitDialog", NULL);
	if (ret){
		if (PyInt_Check(ret) && PyInt_AsLong(ret) == 0){
			Py_DECREF(ret);
			return 0;
		}
		else
			Py_DECREF(ret);
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CWpythonDialog::OnOK()
{
	theApp.CallPython(this, "OnEnter");
}

void CWpythonDialog::OnCancel()
{
	theApp.CallPython(this, "OnEsc");
}

void CWpythonDialog::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	int pos;

	if (pScrollBar)		// Message came from a control
		WpyOnScroll(nSBCode, nPos, pScrollBar);
	else{
		CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
		pos = GetScrollPos(SB_VERT);
		PyObject * ret = Py_BuildValue("(i)", pos);
		theApp.CallPython(this, "WpyPhysOnVScroll", ret);
		Py_DECREF(ret);
	}
}

void CWpythonDialog::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	if (pScrollBar)	// Message came from a control
		WpyOnScroll(nSBCode, nPos, pScrollBar);
	else{
		CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
		long pos = GetScrollPos(SB_HORZ);
		PyObject * args = Py_BuildValue("(i)", pos);
		theApp.CallPython(this, "WpyPhysOnHScroll", args);
		Py_DECREF(args);
	}
}

void CWpythonDialog::PostNcDestroy() 
{
	CDialog::PostNcDestroy();
	if (!m_isModal){
		theApp.UnRecordCpp(this, TRUE);
		delete this;
	}
}

BOOL CWpythonDialog::OnCommand( WPARAM wParam, LPARAM lParam )
{
	if (theApp.PyOnCommand(wParam, lParam))
		return TRUE;
 	return CDialog::OnCommand(wParam, lParam);
}

BOOL CWpythonDialog::OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult) 
{
	switch (message) {
#ifdef MS_WIN16	
	case WM_CTLCOLOR:	// Change to messages MFC 2.5 -> 3.0 -> Win95
#else
	case WM_CTLCOLORDLG:
#endif
		if (!ControlColor(this, message, wParam, lParam, pLResult))
			*pLResult = (LRESULT) ::GetStockObject(LTGRAY_BRUSH);
		return 1;
	}
	return CDialog::OnChildNotify(message, wParam, lParam, pLResult);
}

BOOL CWpythonDialog::PreCreateWindow(CREATESTRUCT& cs) 
{
	long sizex, sizey, x, y, style;	// Try to set window size
	PyObject * pyframe = theApp.GetPythonObject(this);
	if (!GetAttrLong(pyframe, "wpySizeX", &sizex))
		sizex = 200;
	if (!GetAttrLong(pyframe, "wpySizeY", &sizey))
		sizey = 200;
	if (!GetAttrLong(pyframe, "wpyLocX", &x))
		x = 0;
	if (!GetAttrLong(pyframe, "wpyLocY", &y))
		y = 0;
	if (!GetAttrLong(pyframe, "wpyStyle", &style)){
		style = 0;
	}
	//if (x > 0 || y > 0) { Doesn't work!!
	//	cs.x = x;
	//	cs.y = y;
	//}
	//cs.cx = sizex;
	//cs.cy = sizey;
	if (style & WS_DLGFRAME)	// Doesn't work either !!
		cs.style = (cs.style & ~WS_CAPTION) | WS_DLGFRAME;
	return CDialog::PreCreateWindow(cs);
}

void CWpythonDialog::OnSysCommand(UINT nID, LPARAM lParam) 
{
	PyObject * args = Py_BuildValue("(ii)", nID, lParam);
	PyObject * pyobj = theApp.CallPythonRet(this, "OnSysCommand", args);
	Py_DECREF(args);
	int dodefault = 1;
	if (pyobj){
		if (PyInt_Check(pyobj) && PyInt_AsLong(pyobj) == 0)
			dodefault = 0;
		Py_DECREF(pyobj);
	}
	if ( dodefault)
		CDialog::OnSysCommand(nID, lParam);
}
