/*
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Modified to support NeXT's port of PPP-2.2.  Most work was to cover
 * our inability to modify a struct ifnet to contain an if_pcount
 * field.  The disgusting hack of using the PPP softc will cause
 * portability problems with other drivers. A more general solution
 * would be preferrable.  Stephen J. Perkins (perkins@cps.msu.edu)
 * 3/19/95
 *
 */

/*
 * Set/clear promiscuous mode on interface 'ifp' based on the truth value`
 * of pswitch.  The calls are reference counted so that only the first
 * 'on' request actually has an effect, as does the final 'off' request.
 * Results are undefined if the 'off' and 'on' requests are not matched.
 * This code works only with the BSD drivers.
 */

/*
 * All these includes are only necessary so that we can understand the 
 * the "private" data structure placed on the netif_t.  In the case
 * of PPP-2.2, this is a pointer to the ppp_softc structure.  We have
 * added an if_pcount variable there.
 */

#if !defined(lint)
static char sccsid[] = "$Revision: 4.2 $ ($Date: 1995/07/03 18:26:55 $)";
#endif /* not lint*/

#define KERNEL 1
#define KERNEL_FEATURES 1
#define INET 1

#include <sys/param.h>
#include <sys/proc.h>
#include <sys/user.h>
#include "netbuf.h"
#include <sys/socket.h>
#include <sys/ioctl.h>

#include <sys/errno.h>


#include <kernserv/prototypes.h>
#if defined(m68k)
#import "spl.h"
#else
#include <driverkit/generalFuncs.h>
#import <kernserv/machine/spl.h>
#endif
#include <kernserv/kern_server_types.h>

#include <net/if.h>
#include <net/route.h>

#if INET
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#endif


#include <net/ppp_defs.h>
#ifdef	VJC
#include <net/vjcompress.h>
#endif
#include <net/if_ppp.h>

#include "if_pppvar.h"

int
bpfifpromisc(ifp, pswitch)
	netif_t ifp;
	int pswitch;
{
  struct ppp_softc *sc = (struct ppp_softc *) if_private(ifp);

  /* 
   * If the device is not configured up, we cannot put it in
   * promiscuous mode.
   */
  if ((if_flags(ifp) & IFF_UP) == 0)
    return ENETDOWN;
  
  if (pswitch) {
    if (sc->if_pcount++ != 0)
      return 0;
    /* turn on driver */
    if_flags_set(ifp, if_flags(ifp) | IFF_PROMISC);
  } else {
    if (--sc->if_pcount > 0)
      return 0;
    /* turn off driver */
    if_flags_set(ifp, if_flags(ifp) & ~IFF_PROMISC);
  }
}
