#if !defined(lint)
static char sccsid[] = "$Revision: 4.2 $ ($Date: 1995/07/03 18:26:45 $)";
#endif /* not lint*/


#if NBPFILTER > 0


#include <sys/param.h>
#include <sys/systm.h>
#include "netbuf.h"
#include <sys/buf.h>
#include <sys/time.h>
#include <sys/proc.h>
#include <machine/user.h>
#include <sys/ioctl.h>

#include <sys/file.h>
#include <sys/tty.h>
#include <sys/uio.h>

#include <sys/protosw.h>
#include <sys/socket.h>
#include <net/if.h>

#include "bpf.h"
#include "bpfdesc.h"
#include <sys/errno.h>
#include <sys/kernel.h>
#include <sys/conf.h>

#if defined(m68k)
#import "spl.h"
#else
#import <kernserv/machine/spl.h>
#endif


static struct cdevsw bpf_saved_cdevsw;

extern int bpfopen(), bpfclose(), bpfread(), bpfwrite(),
       bpfioctl(), bpfselect();

static struct cdevsw bpf_cdevsw =  { 
  bpfopen,
  bpfclose,
  bpfread,
  bpfwrite,
  bpfioctl,
  nodev,
  nulldev,
  bpfselect,
  nodev,
  nodev,
  nodev };


int
bpfalloc ()
{
    printf("BPF version %d.%d NS 3.2 and 3.3\n", BPF_MAJOR_VERSION,
	   BPF_MINOR_VERSION);
    printf("LKS: %s\n", sccsid);
    printf("Using Major device %d\n", BPF_MAJOR_CHAR);
    printf("by Stephen Perkins <perkins@cps.msu.edu>\n");

  /* Save whatever entries were in the tables for our major numbers. */
  bpf_saved_cdevsw = cdevsw[BPF_MAJOR_CHAR];
  
  /* Put my entries in the switch tables. */
  cdevsw[BPF_MAJOR_CHAR]  = bpf_cdevsw;
  return 1;
}

int
bpfdealloc()
{
  cdevsw[BPF_MAJOR_CHAR] = bpf_saved_cdevsw;
  printf("\n Thank you for using BPF\n\n");
  return 0;
}


#endif
