/*  Hey Emacs, switch to -*-C-*-, please 

Copyright (C) 1997 Tage Stabell-Kul (tage@acm.org).  All rights
reserved.

This is a package, containing a library, that makes it possible for
programmers to include security functionality in their programs, in a
format compatible with PGP.

This library is free for commercial and non-commercial use as long as
the following conditions are aheared to:

Copyright remains Tage Stabell-Kul's, and as such any Copyright
notices in the code are not to be removed.
If this package is used in a product, Tage Stabell-Kul should be given
attribution as the author of the parts of the library used.
This can be in the form of a textual message at program startup or
in documentation (online or textual) provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:
   "This product includes software written by
    Tage Stabell-Kul (tage@acm.org)"

THIS SOFTWARE IS PROVIDED BY TAGE STABELL-KUL ``AS IS'' AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The licence and distribution terms for any publically available
version or derivative of this code cannot be changed.  i.e. this code
cannot simply be copied and put under another distribution licence
[including the GNU Public Licence.]

The reason behind this being stated in this direct manner is past
experience in code simply being copied and the attribution removed
from it and then being distributed as part of other packages. This
implementation was a non-trivial and unpaid effort.


 */

#include <stdio.h>
#include <ctype.h>

#include <malloc.h>
#include <pgplib.h>
#include "shell.h"

void
base_open(int argc, char *argv[])
{
    int		force, writer;
    char	*p;

    if (argc !=2 && argc != 3 ) {
	fprintf(stdout, "DBOPEN name.  Opens name.{keys,string,keyid} as database\n");
	return;
    }
    force = writer = 0;
    if ( argc == 3 ) {
	for(p=argv[2]; *p != NULL; p++)
	    *p = tolower(*p);
	if ( ! strcmp(argv[2], "force"))
	    force = 1;    
	else if ( ! strcmp(argv[2], "writer"))
	    writer = 1;
	else {
	    fprintf(stderr, "DBOPEN: arg 3 MUST be \"writer\" or \"force\" or nothing (not \"%s\")\n",
		    argv[2]);
	    return;
	}
    }
    if ( force == 1 )
	keydb_init(argv[1], NEWDB);
    else if ( writer == 1 )
	keydb_init(argv[1], WRITER);
    else
	keydb_init(argv[1], READER);

    return;
}
