/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.util.Iterator;
import java.util.LinkedList;
import org.openantivirus.scanner.Node;
import org.openantivirus.scanner.PositionFoundListener;

public class Trie {
    public static final String VERSION = "$Id: Trie.java,v 1.1 2001/12/12 23:59:38 kurti Exp $";
    public static final int MINIMUM_LENGTH = 3;
    private Node nRoot = new Node();

    public void addString(String string, PositionFoundListener positionFoundListener) {
        if (string.length() < 3) {
            throw new IllegalArgumentException("String too short");
        }
        Node node = this.nRoot;
        int n = 0;
        while (n < 3) {
            char c = string.charAt(n);
            Node node2 = node.getNext(c);
            if (node2 == null) {
                node2 = new Node();
                node.setNext(c, node2);
            }
            node = node2;
            ++n;
        }
        node.setLastNode(true);
        node.addPositionFoundListener(positionFoundListener);
    }

    protected void createFailureTransitions() {
        Object object;
        this.nRoot.setFailure(null);
        Object object2 = new LinkedList<Object>();
        int n = 0;
        while (n < 256) {
            object = this.nRoot.getNext(n);
            if (object != null) {
                ((Node)object).setFailure(this.nRoot);
                object2.add(object);
            }
            ++n;
        }
        while (!object2.isEmpty()) {
            object = new LinkedList();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                int n2 = 0;
                while (n2 < 256) {
                    Node node2 = node.getNext(n2);
                    if (node2 != null) {
                        object.add(node2);
                        Node node3 = node.getFailure();
                        while (node3 != null && node3.getNext(n2) == null) {
                            node3 = node3.getFailure();
                        }
                        if (node3 == null) {
                            node2.setFailure(this.nRoot.getNext(n2));
                        } else {
                            node2.setFailure(node3.getNext(n2));
                        }
                    }
                    ++n2;
                }
            }
            object2 = object;
        }
    }

    protected void createFastTrie(Node node) {
        int n = 0;
        while (n < 256) {
            Node node2 = node.getNext(n);
            if (node2 == null) {
                Node node3 = node;
                while ((node3 = node3.getFailure()) != null && node3.getNext(n) == null) {
                }
                node.setTrans(n, node3 == null ? this.nRoot : node3.getNext(n));
            } else {
                node.setTrans(n, node2);
                if (!node.isLastNode()) {
                    this.createFastTrie(node2);
                }
            }
            ++n;
        }
    }

    public Node getRootNode() {
        return this.nRoot;
    }

    public void prepare() {
        this.createFailureTransitions();
        this.createFastTrie(this.nRoot);
    }
}

