/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import org.openantivirus.scanner.RecursiveFileFilter;
import org.openantivirus.scanner.StreamFileFilter;
import org.openantivirus.scanner.StringFinder;
import org.openantivirus.scanner.StringVirusFinder;
import org.openantivirus.scanner.Trie;
import org.openantivirus.scanner.TrieScanner;
import org.openantivirus.scanner.VirusFoundException;

public class ScannerDaemon {
    public static final String VERSION = "$Id: ScannerDaemon.java,v 1.4 2001/12/12 23:59:38 kurti Exp $";
    public static final int PORT = 8127;
    private boolean isRunning;
    private RecursiveFileFilter rff;

    public ScannerDaemon(String string) throws IOException {
        Trie trie = new Trie();
        new StringVirusFinder(new FileReader(string != null ? string : "virussignatures.txt"), new StringFinder(trie));
        trie.prepare();
        this.rff = new RecursiveFileFilter(new StreamFileFilter(new TrieScanner(trie)));
    }

    public void start() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(8127);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.isRunning = true;
        while (this.isRunning) {
            try {
                String string;
                Socket socket = serverSocket.accept();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                try {
                    this.rff.filter(new File(string2));
                    string = "OK\n";
                }
                catch (VirusFoundException virusFoundException) {
                    string = virusFoundException.getMessage() + "\n";
                }
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(string.getBytes());
                outputStream.close();
                bufferedReader.close();
                socket.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            new ScannerDaemon(stringArray.length > 0 ? stringArray[0] : null).start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

