/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*  Xavier Leroy and Pascal Cuoq, projet Cristal, INRIA Rocquencourt   */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  en Automatique.  All rights reserved.  This file is distributed    */
/*  under the terms of the GNU Library General Public License.         */
/*                                                                     */
/***********************************************************************/

/* $Id: connect.c,v 1.6 2000/03/16 13:35:19 xleroy Exp $ */

#include <mlvalues.h>
#include "unixsupport.h"
#include "socketaddr.h"

value unix_connect(socket, address)   /* ML */
     value socket, address;
{
  SOCKET s = (SOCKET) Handle_val(socket);
  int retcode;
  union sock_addr_union addr;
  socklen_param_type addr_len;

  get_sockaddr(address, &addr, &addr_len);
  enter_blocking_section();
  retcode = connect(s, &addr.s_gen, addr_len);
  leave_blocking_section();
  if (retcode == -1) unix_error(WSAGetLastError(), "connect", Nothing);
  return Val_unit;
}
