/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1998 Institut National de Recherche en Informatique et   */
/*  en Automatique.  All rights reserved.  This file is distributed    */
/*  under the terms of the GNU Library General Public License.         */
/*                                                                     */
/***********************************************************************/

/* $Id: putenv.c,v 1.6 2000/11/23 13:45:00 doligez Exp $ */

#include <stdlib.h>
#include <string.h>

#include <memory.h>
#include <mlvalues.h>

#include "unixsupport.h"

#ifdef HAS_PUTENV

value unix_putenv(value name, value val) /* ML */
{
  mlsize_t namelen = string_length(name);
  mlsize_t vallen = string_length(val);
  char * s = (char *) stat_alloc(namelen + 1 + vallen + 1);

  memmove (s, String_val(name), namelen);
  s[namelen] = '=';
  memmove (s + namelen + 1, String_val(val), vallen);
  s[namelen + 1 + vallen] = 0;
  if (putenv(s) == -1) uerror("putenv", name);
  return Val_unit;
}

#else

value unix_putenv(value name, value val)
{ invalid_argument("putenv not implemented"); }

#endif
