/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*             Damien Doligez, projet Para, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1997 Institut National de Recherche en Informatique et   */
/*  en Automatique.  All rights reserved.  This file is distributed    */
/*  under the terms of the GNU Library General Public License.         */
/*                                                                     */
/***********************************************************************/

/* $Id: aboutbox.c,v 1.4 2000/04/20 13:41:22 doligez Exp $ */

#include "main.h"

static WindowPtr aboutbox = NULL;
static UserItemUPP DrawAboutUPP = NULL;

#define kItemText 2

static pascal void DrawAbout (DialogPtr d, short item)
{
#pragma unused (item)
  WEHandle we = WinGetWE (d);

  Assert (we != NULL);
  WEUpdate (d->visRgn, we);
}

void OpenAboutBox (void)
{
  OSErr err;
  short itemtype;
  Handle item;
  Rect itemrect;
  LongRect lr;
  WEHandle we = NULL;
  WStatusH st = NULL;
  Handle txt = NULL, copr = NULL;
  TextStyle ts;

  if (DrawAboutUPP == NULL) DrawAboutUPP = NewUserItemProc (DrawAbout);

  if (aboutbox != NULL){
    SelectWindow (aboutbox);
  }else{
    aboutbox = GetNewDialog (kDialogAbout, NULL, (WindowPtr) -1L);
    if (aboutbox == NULL){
      err = memFullErr;
      goto failed;
    }
    SetPort (aboutbox);

    err = WinAllocStatus (aboutbox);
    if (err != noErr) goto failed;

    st = WinGetStatus (aboutbox);
    Assert (st != NULL);
    (*st)->kind = kWinAbout;

    GetDialogItem (aboutbox, kItemText, &itemtype, &item, &itemrect);
    SetDialogItem (aboutbox, kItemText, itemtype, (Handle) DrawAboutUPP, &itemrect);
    WERectToLongRect (&itemrect, &lr);
    err = WENew (&lr, &lr, 0, &we);
    if (err != noErr) goto failed;

    (*st)->we = we;

    GetFNum ("\pGeneva", &ts.tsFont);
    ts.tsSize = 10;
    err = WESetStyle (weDoFont + weDoSize, &ts, we);
    if (err != noErr) goto failed;

    txt = GetResource ('TEXT', kAboutText1);
    err = ResError (); if (err != noErr){ err = noErr; goto failed; }
    DetachResource (txt);

    copr = GetResource ('TEXT', kAboutText2);
    err = ResError ();
    if (err == noErr){
      HLock (copr);
      err = HandAndHand (copr, txt);
      /* ignore errors */
      HUnlock (copr);
      ReleaseResource (copr);
      copr = NULL;
    }

    err = WEUseText (txt, we);
    if (err != noErr) goto failed;
    err = WECalText (we);
    if (err != noErr) goto failed;

    WEFeatureFlag (weFReadOnly, weBitSet, we);

    return;

    failed:
    if (copr != NULL) DisposeHandle (copr);
    if (txt != NULL) DisposeHandle (txt);
    if (we != NULL) WEDispose (we);
    if (st != NULL) DisposeHandle ((Handle) st);
    if (aboutbox != NULL) DisposeWindow (aboutbox);
    aboutbox = NULL;
    ErrorAlertGeneric (err);
  }
}

void CloseAboutBox (WindowPtr w)
{
  WStatusH st = WinGetStatus (w);
  WEHandle we = WinGetWE (w);

  Assert (w == aboutbox);

  Assert (we != NULL);
  WEDispose (we);
  Assert (st != NULL);
  DisposeHandle ((Handle) st);
  Assert (w != NULL);
  DisposeDialog (w);
  aboutbox = NULL;
}
