(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*          Jerome Vouillon, projet Cristal, INRIA Rocquencourt        *)
(*          Objective Caml port by John Malecki and Xavier Leroy       *)
(*                                                                     *)
(*  Copyright 1996 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* $Id: checkpoints.mli,v 1.2 1997/03/30 19:43:01 vouillon Exp $ *)

(***************************** Checkpoints *****************************)

open Primitives
open Debugcom

(*** A type for checkpoints. ***)

type checkpoint_state =
    C_stopped
  | C_running of int

(* `c_valid' is true if and only if the corresponding
 * process is connected to the debugger.
 * `c_parent' is the checkpoint whose process is parent
 * of the checkpoint one (`root' if no parent).
 * c_pid =  2 for root pseudo-checkpoint.
 * c_pid =  0 for ghost checkpoints.
 * c_pid = -1 for kill checkpoints.
 *)
type checkpoint =
  {mutable c_time : int;
   mutable c_pid : int;
   mutable c_fd : io_channel;
   mutable c_valid : bool;
   mutable c_report : report option;
   mutable c_state : checkpoint_state;
   mutable c_parent : checkpoint;
   mutable c_breakpoint_version : int;
   mutable c_breakpoints : (int * int ref) list;
   mutable c_trap_barrier : int}

(*** Pseudo-checkpoint `root'. ***)
(* --- Parents of all checkpoints which have no parent. *)
val root : checkpoint

(*** Current state ***)
val checkpoints : checkpoint list ref
val current_checkpoint : checkpoint ref

val current_time : unit -> int
val current_report : unit -> report option
val current_pc : unit -> int option
val current_pc_sp : unit -> (int * int) option
