#open "code";;

type tat_de_l'assembleur =
   { mutable pc: int;
     mutable code: instruction vect;
     mutable table_tiq: (string, int) hashtbl__t;
     mutable _rsoudre: (int * string) list };;

let asm =
  { pc = 0; code = [||]; table_tiq = hashtbl__new 0;
    _rsoudre = [] };;

let initialise () =
    asm.pc <- 0;
    asm.code <- make_vect 100 Stop;
    asm.table_tiq <- hashtbl__new 17;
    asm._rsoudre <- [];;

let dcode_adresse adr = adr / taille_du_mot;;

let assemble instruction =
    if asm.pc >= vect_length asm.code then begin
      let nouveau_code = make_vect (2 * vect_length asm.code) Stop in
      blit_vect asm.code 0 nouveau_code 0 (vect_length asm.code);
      asm.code <- nouveau_code
    end;
    asm.code.(dcode_adresse asm.pc) <- instruction;
    asm.pc <- asm.pc + taille_du_mot;;

let dfinir_tiquette nom_tiq val_tiq =
    try
      let dj_dfinie = hashtbl__find asm.table_tiq nom_tiq in
      raise (Erreur ("tiquette " ^ nom_tiq ^ " redfinie"))
    with Not_found ->
      hashtbl__add asm.table_tiq nom_tiq val_tiq;;

let poser_tiquette nom_tiq =
    dfinir_tiquette nom_tiq asm.pc;;

let valeur_tiquette nom_tiq =
    try
       hashtbl__find asm.table_tiq nom_tiq
    with Not_found ->
       asm._rsoudre <- (asm.pc, nom_tiq) :: asm._rsoudre;
       0;;
let rsoudre_tiquette (adresse, nom_tiq) =
    let valeur =
        try
          hashtbl__find asm.table_tiq nom_tiq
        with Not_found ->
          raise (Erreur ("tiquette " ^ nom_tiq ^ " indfinie")) in
    let nouvelle_instruction =
        match asm.code.(dcode_adresse adresse) with
        | Op(opration, reg1, _, reg2) ->
            Op(opration, reg1, Imm valeur, reg2)
        | Jmp(_, reg) ->
            Jmp(Imm valeur, reg)
        | Braz(reg, _) ->
            Braz(reg, valeur)
        | Branz(reg, _) ->
            Branz(reg, valeur)
        | _ -> raise (Erreur "rsoudre_tiquette") in
    asm.code.(dcode_adresse adresse) <- nouvelle_instruction;;

let extraire_code () =
    do_list rsoudre_tiquette asm._rsoudre;
    sub_vect asm.code 0 (dcode_adresse asm.pc);;
