#open "syntaxe";;
#open "eval";;

let code_nombre n =
    Val_nombre n
and dcode_nombre = function
  | Val_nombre n -> n
  | _ -> raise(Erreur "entier attendu")
and code_boolen b =
    Val_boolenne b
and dcode_boolen = function
  | Val_boolenne b -> b
  | _ -> raise(Erreur "boolen attendu");;

(* Pour transformer une fonction Caml en valeur fonctionnelle *)

let prim1 codeur calcul dcodeur =
  Val_primitive(function val -> codeur(calcul(dcodeur val)))
and prim2 codeur calcul dcodeur1 dcodeur2 =
  Val_primitive(function
  | Val_paire(v1, v2) ->
      codeur(calcul (dcodeur1 v1) (dcodeur2 v2))
  | _ -> raise(Erreur "paire attendue"));;

(* L'environnement initial *)

let env_initial =
  ["+",  prim2 code_nombre  (prefix + ) dcode_nombre dcode_nombre;
   "-",  prim2 code_nombre  (prefix - ) dcode_nombre dcode_nombre;
   "*",  prim2 code_nombre  (prefix * ) dcode_nombre dcode_nombre;
   "/",  prim2 code_nombre  (prefix / ) dcode_nombre dcode_nombre;
   "=",  prim2 code_boolen (prefix = ) dcode_nombre dcode_nombre;
   "<>", prim2 code_boolen (prefix <>) dcode_nombre dcode_nombre;
   "<",  prim2 code_boolen (prefix < ) dcode_nombre dcode_nombre;
   ">",  prim2 code_boolen (prefix > ) dcode_nombre dcode_nombre;
   "<=", prim2 code_boolen (prefix <=) dcode_nombre dcode_nombre;
   ">=", prim2 code_boolen (prefix >=) dcode_nombre dcode_nombre;
   "not", prim1 code_boolen (prefix not) dcode_boolen;
   "read_int", prim1 code_nombre (fun x -> read_int()) dcode_nombre;
   "write_int", prim1 code_nombre
                      (fun x -> print_int x; print_newline(); 0)
                      dcode_nombre];;
let boucle () =
  let env_global = ref env_initial in
  let flux_d'entre = stream_of_channel std_in in
  while true do
    print_string "# "; flush std_out;
    try
      match lire_phrase flux_d'entre with
      | Expression expr ->
          let rs = value !env_global expr in
          print_string "- = "; imprime_valeur rs;
          print_newline()
      | Dfinition df ->
          let nouvel_env = value_dfinition !env_global df in
          begin match nouvel_env with
          | (nom, val) :: _ ->
              print_string nom; print_string " = ";
              imprime_valeur val; print_newline()
          | _ -> failwith "mauvaise gestion des dfinitions"
          end;
          env_global := nouvel_env
    with
      Parse_error | Parse_failure ->
        print_string "Erreur de syntaxe"; print_newline()
    | Erreur msg ->
        print_string "Erreur  l'valuation: "; print_string msg;
        print_newline()
  done;;

if sys__interactive then () else boucle();;
