type table_de_codage =
  { caractre: int list vect;
    mutable fin: int list };;

let encode entre sortie codage =
  esbit__initialise();
  try
    while true do
      let c = input_char entre in
      do_list (esbit__crire_bit sortie)
              codage.caractre.(int_of_char c)
    done
  with End_of_file ->           (* fin du fichier d'entre *)
    do_list (esbit__crire_bit sortie) codage.fin;
    esbit__finir sortie;;
type arbre_de_huffman =
  | Lettre of char
  | Fin
  | Noeud of arbre_de_huffman * arbre_de_huffman;;

let dcode entre sortie arbre =
  esbit__initialise();
  let rec parcours = function
  | Fin -> ()
  | Lettre c ->
      output_char sortie c; parcours arbre
  | Noeud(gauche, droite) ->
      if esbit__lire_bit entre = 0
      then parcours gauche
      else parcours droite in
  parcours arbre;;
let frquences entre =
  let fr = make_vect 256 0 in
  begin try
    while true do
      let c = int_of_char(input_char entre) in fr.(c) <- fr.(c) + 1
    done
  with End_of_file -> ()
  end;
  fr;;
let construire_arbre frquences =
  let prio = ref (fileprio__ajoute fileprio__vide 1 Fin) in
  let nombre_d'arbres = ref 1 in
  for c = 0 to 255 do
    if frquences.(c) > 0 then begin
      prio := fileprio__ajoute !prio
                frquences.(c) (Lettre(char_of_int c));
      incr nombre_d'arbres
    end
  done;
  for n = !nombre_d'arbres downto 2 do
    let (frq1, arbre1, prio1) = fileprio__extraire !prio in
    let (frq2, arbre2, prio2) = fileprio__extraire prio1 in
    prio := fileprio__ajoute prio2
              (frq1 + frq2) (Noeud(arbre1,arbre2))
  done;
  let (_, arbre, _) = fileprio__extraire !prio in
  arbre;;
let arbre_vers_codage arbre =
  let codage = { caractre = make_vect 256 []; fin = [] } in
  let rec remplir_codage prfixe = function
  | Lettre c ->
      codage.caractre.(int_of_char c) <- rev prfixe
  | Fin ->
      codage.fin <- rev prfixe
  | Noeud(arbre1, arbre2) ->
      remplir_codage (0 :: prfixe) arbre1;
      remplir_codage (1 :: prfixe) arbre2 in
  remplir_codage [] arbre;
  codage;;
let compresse entre sortie =
  let frq = frquences entre in
  let arbre = construire_arbre frq in
  let codage = arbre_vers_codage arbre in
  output_value sortie arbre;
  seek_in entre 0;
  encode entre sortie codage;;
let dcompresse entre sortie =
  let arbre = input_value entre in
  dcode entre sortie arbre;;
