let recule d = avance (-. d)
and tourne__droite a = tourne (-. a)
and tourne__gauche = tourne;;
let baisse_le_crayon () = fixe_crayon false
and lve_le_crayon () = fixe_crayon true;;
let rpte n l =
    for i = 1 to n do l done;;
rpte 4 [print_int 1; print_char `*`];;
let rpte n liste_d'ordres =
    for i = 1 to n do liste_d'ordres() done;;
rpte 4 (function () -> print_int 1; print_char `*`);;
type nombre =
   | Entier of int
   | Flottant of float;;
let flottant = function
  | Entier i -> float_of_int i
  | Flottant f -> f;;
type ordre =
   | Av of nombre | Re of nombre
   | Td of nombre | Tg of nombre
   | Lc | Bc
   | Ve
   | Rep of int * ordre list;;
let rec excute_ordre = function
  | Av n -> avance (flottant n)
  | Re n -> avance (-. (flottant n))
  | Tg a -> tourne (flottant a)
  | Td a -> tourne (-. (flottant a))
  | Lc -> fixe_crayon true
  | Bc -> fixe_crayon false
  | Ve -> vide_cran()
  | Rep (n, l) -> for i = 1 to n do do_list excute_ordre l done;;
let excute_programme l = do_list excute_ordre l;;
let carr c = Rep (4, [Av c; Td (Entier 90)]);;
excute_programme
 [Ve; carr (Entier 100); carr (Entier 75);
  carr (Entier 50); carr (Entier 25);
  carr (Flottant 12.5); carr (Flottant 6.25);
  carr (Flottant 3.125)];;
type lexme =
   | Mot of string
   | Symbole of char
   | Constante_entire of int
   | Constante_flottante of float;;
let flux_car = stream_of_string "Vive Caml!";;
let flux_ent = [< '2; '3; '5; '7 >];;
stream_next flux_car;;
stream_next flux_car;;
let rec saute_blancs flux =
  match flux with
  | [< ' ` ` >] -> saute_blancs flux  (* ` ` est l'espace *)
  | [< ' `\t` >] -> saute_blancs flux (* `\t` est la tabulation *)
  | [< ' `\n` >] -> saute_blancs flux (* `\n` est la fin de ligne *)
  | [< >] -> ();;
let rec saute_blancs flux =
  match flux with
  | [< ' (` ` | `\t` | `\n`) >] -> saute_blancs flux
  | [< >] -> ();;
let rec lire_entier accumulateur flux =
  match flux with
  | [< '(`0`..`9` as c) >] ->
      lire_entier (10 * accumulateur + int_of_char c - 48) flux
  | [< >] -> accumulateur;;
let flux_car = stream_of_string "123/456";;
lire_entier 0 flux_car;;
stream_next flux_car;;
lire_entier 900 flux_car;;
let rec lire_dcimales accumulateur chelle flux =
  match flux with
  | [< '(`0`..`9` as c) >] ->
      lire_dcimales
        (accumulateur +.
           float_of_int(int_of_char c - 48) *. chelle)
        (chelle /. 10.0) flux
  | [< >] -> accumulateur;;
lire_dcimales 123.4 0.01 (stream_of_string "56789");;
let tampon = "----------------";;
let rec lire_mot position flux =
  match flux with
  | [< '(`A`..`Z` | `a`..`z` | `` | `` | `_` as c) >] ->
      if position < string_length tampon then
        set_nth_char tampon position c;
      lire_mot (position+1) flux
  | [< >] ->
      sub_string tampon 0 (min position (string_length tampon));;
let rec lire_lexme flux =
  saute_blancs flux;
  match flux with
  | [< '(`A`..`Z` | `a`..`z` | `` | `` as c) >] ->
      set_nth_char tampon 0 c;
      Mot(lire_mot 1 flux)
  | [< '(`0`..`9` as c) >] ->
      let n = lire_entier (int_of_char c - 48) flux in
      begin match flux with
      | [< '`.` >] ->
          Constante_flottante
            (lire_dcimales (float_of_int n) 0.1 flux)
      | [< >] -> Constante_entire(n)
      end
  | [< 'c >] -> Symbole c;;
let flux_car = stream_of_string "123bonjour   ! 45.67";;
lire_lexme flux_car;;
lire_lexme flux_car;;
lire_lexme flux_car;;
lire_lexme flux_car;;
let rec analyseur_lexical flux =
 match flux with
 | [< lire_lexme l >] -> [< 'l; analyseur_lexical flux >]
 | [< >] -> [< >];;
let flux_lexmes =
    analyseur_lexical(stream_of_string "123bonjour   ! 45.67");;
stream_next flux_lexmes;;
stream_next flux_lexmes;;
stream_next flux_lexmes;;
stream_next flux_lexmes;;
let nombre = function
  | [< 'Constante_entire i >] -> Entier i
  | [< 'Constante_flottante f >] -> Flottant f;;
let flux_lexmes =
    analyseur_lexical(stream_of_string "123 1.05 fini");;
nombre flux_lexmes;;
nombre flux_lexmes;;
nombre flux_lexmes;;
let rec ordre = function
  | [< 'Mot "baisse_crayon" >] -> Bc
  | [< 'Mot "bc" >] -> Bc
  | [< 'Mot "lve_crayon" >] -> Lc
  | [< 'Mot "lc" >] -> Lc
  | [< 'Mot "vide_cran" >] -> Ve
  | [< 'Mot "ve" >] -> Ve
  | [< 'Mot "avance"; nombre n >] -> Av n
  | [< 'Mot "av"; nombre n >] -> Av n
  | [< 'Mot "recule"; nombre n >] -> Re n
  | [< 'Mot "re"; nombre n >] -> Re n
  | [< 'Mot "droite"; nombre n >] -> Td n
  | [< 'Mot "td"; nombre n >] -> Td n
  | [< 'Mot "gauche"; nombre n >] -> Tg n
  | [< 'Mot "tg"; nombre n >] -> Tg n
  | [< 'Mot "rpte"; 'Constante_entire n;
       liste_d'ordres l >] -> Rep (n,l)
  | [< 'Mot "rep"; 'Constante_entire n;
       liste_d'ordres l >] -> Rep (n,l)
and liste_d'ordres = function
  | [< 'Symbole `[`; suite_d'ordres l; 'Symbole `]` >] -> l
and suite_d'ordres = function
  | [< ordre ord; suite_d'ordres l_ord >] -> ord::l_ord
  | [<>] -> [];;
let analyse_programme = function
  | [< suite_d'ordres l; 'Symbole `.` >] -> l;;
let lire_code chane =
    analyse_programme
      (analyseur_lexical (stream_of_string chane));;
lire_code "rpte 4 [avance 100 droite 90].";;
let logo chane =
    excute_programme (lire_code chane);;
logo "ve rpte 6
           [td 60 rpte 6 [av 15 tg 60] av 15].";;
type expression =
   | Constante of nombre
   | Somme of expression * expression
   | Produit of expression * expression
   | Diffrence of expression * expression
   | Quotient of expression * expression
   | Variable of string;;
let ajoute_nombres = function
  | (Entier i, Entier j) -> Entier (i + j)
  | (n1, n2) -> Flottant (flottant n1 +. flottant n2)
and soustrais_nombres = function
  | (Entier i, Entier j) -> Entier (i - j)
  | (n1, n2) -> Flottant (flottant n1 -. flottant n2)
and multiplie_nombres = function
  | (Entier i, Entier j) -> Entier (i * j)
  | (n1, n2) -> Flottant (flottant n1 *. flottant n2)
and divise_nombres = function
  | (Entier i, Entier j) -> Entier (i / j)
  | (n1, n2) -> Flottant (flottant n1 /. flottant n2)
and compare_nombres = function
  | (Entier i, Entier j) -> i >= j
  | (n1, n2) -> (flottant n1 >=. flottant n2);;
let rec valeur_expr env = function
  | Constante n -> n
  | Somme (e1, e2) ->
     ajoute_nombres (valeur_expr env e1, valeur_expr env e2)
  | Produit (e1, e2) ->
     multiplie_nombres (valeur_expr env e1, valeur_expr env e2)
  | Diffrence (e1, e2) ->
     soustrais_nombres (valeur_expr env e1, valeur_expr env e2)
  | Quotient (e1, e2) ->
     divise_nombres (valeur_expr env e1, valeur_expr env e2)
  | Variable s -> assoc s env;;
type ordre =
   | Av of expression | Re of expression
   | Td of expression | Tg of expression
   | Lc | Bc
   | Ve
   | Rep of expression * ordre list
   | Stop
   | Si of expression * expression * ordre list * ordre list
   | Excute of string * expression list;;
type procdure = {Paramtres : string list; Corps : ordre list};;
let procdures_dfinies = ref ([] : (string * procdure) list);;
let dfinit_procdure (nom, proc as liaison) =
    procdures_dfinies := liaison :: !procdures_dfinies
and dfinition_de nom_de_procdure =
    assoc nom_de_procdure !procdures_dfinies;;
let valeur_entire = function
  | Entier i -> i
  | Flottant f -> failwith "entier attendu";;
exception Fin_de_procdure;;
let rec excute_ordre env = function
  | Av e -> avance (flottant (valeur_expr env e))
  | Re e -> avance (-. (flottant (valeur_expr env e)))
  | Tg a -> tourne (flottant (valeur_expr env a))
  | Td a -> tourne (-. (flottant (valeur_expr env a)))
  | Lc -> fixe_crayon true
  | Bc -> fixe_crayon false
  | Ve -> vide_cran()
  | Rep (n, l) ->
     for i = 1 to valeur_entire (valeur_expr env n)
     do do_list (excute_ordre env) l done
  | Si (e1, e2, alors, sinon) ->
     if compare_nombres (valeur_expr env e1, valeur_expr env e2)
     then do_list (excute_ordre env) alors
     else do_list (excute_ordre env) sinon
  | Stop -> raise Fin_de_procdure
  | Excute (nom_de_procdure, args) ->
     let dfinition = dfinition_de nom_de_procdure in
     let variables = dfinition.Paramtres
     and corps = dfinition.Corps in
     let rec augmente_env = function
       | [],[] -> env
       | variable :: vars, expr :: exprs ->
          (variable, valeur_expr env expr) ::
          augmente_env (vars, exprs)
       | _ ->
          failwith ("mauvais nombre d'arguments pour "
                    ^ nom_de_procdure) in
     let env_pour_corps = augmente_env (variables, args) in
     try  do_list (excute_ordre env_pour_corps) corps
     with Fin_de_procdure -> ();;
type phrase_logo =
   | Pour of string * procdure
   | Ordre of ordre;;
type programme_logo = Programme of phrase_logo list;;
let rec excute_phrase = function
  | Ordre ord -> excute_ordre [] ord
  | Pour (nom, proc as liaison) -> dfinit_procdure liaison
and excute_programme = function
  | Programme phs -> do_list excute_phrase phs;;
let logo chane =
    do_list excute_phrase
     (analyse_programme
       (analyseur_lexical (stream_of_string chane)));;
logo "pour carr :c
        rpte 4 [av :c td 90].
      pour multi_carr :c :n
        rpte :n [carr :c td 10].
      ve multi_carr 80 10 .";;
logo "pour spirale :d :a :i :n
       si :n >= 0
        [av :d td :a spirale (:d + :i) :a :i (:n - 1)]
        [stop].";;
logo "ve spirale
      0 179.5 0.5 360 .";;
logo "ve spirale
      0 178.5 0.5 360 .";;
logo "ve spirale
      0 79.8 0.4 360 .";;
logo "ve spirale
      0 79.5 0.4 360 .";;
%% logo "ve spirale -180.0 79.5 0.5 720 .";;
logo "pour spirala :d :a :i :n
       si :n >= 0
        [av :d td :a spirala :d (:a + :i) :i (:n - 1)]
        [stop].";;
%%% logo "ve spirala 10 0 2.5 90 .";;
logo "ve spirala
      5 0 89.5 1440 .";;
logo "ve spirala
      4 0.5 181.5 1500 .";;
